/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

public final class OctetConverter {
    private OctetConverter() {
    }

    public static int octetsToInt(byte[] octets, int offset) {
        return (octets[offset] & 0xFF) << 24 | (octets[offset + 1] & 0xFF) << 16 | (octets[offset + 2] & 0xFF) << 8 | octets[offset + 3] & 0xFF;
    }

    public static int octetsToInt(byte[] octets) {
        return OctetConverter.octetsToInt(octets, 0);
    }

    public static long octetsToLong(byte[] octets, int offset) {
        return ((long)octets[offset] & 0xFFFFL) << 56 | ((long)octets[offset + 1] & 0xFFL) << 48 | ((long)octets[offset + 2] & 0xFFL) << 40 | ((long)octets[offset + 3] & 0xFFL) << 32 | ((long)octets[offset + 4] & 0xFFL) << 24 | ((long)octets[offset + 5] & 0xFFL) << 16 | ((long)octets[offset + 6] & 0xFFL) << 8 | (long)octets[offset + 7] & 0xFFL;
    }

    public static long octetsToLong(byte[] octets) {
        return OctetConverter.octetsToLong(octets, 0);
    }

    public static void octetsToString(StringBuffer buffer, byte[] octets, int offset) {
        buffer.append(octets[offset++] & 0xFF);
        buffer.append(".");
        buffer.append(octets[offset++] & 0xFF);
        buffer.append(".");
        buffer.append(octets[offset++] & 0xFF);
        buffer.append(".");
        buffer.append(octets[offset++] & 0xFF);
    }

    public static void octetsToString(StringBuffer buffer, byte[] octets) {
        OctetConverter.octetsToString(buffer, octets, 0);
    }

    public static void intToString(StringBuffer buffer, int address) {
        buffer.append(0xFF & address >>> 24);
        buffer.append(".");
        buffer.append(0xFF & address >>> 16);
        buffer.append(".");
        buffer.append(0xFF & address >>> 8);
        buffer.append(".");
        buffer.append(0xFF & address);
    }

    public static void intToOctets(int address, byte[] octets, int offset) {
        octets[offset] = (byte)(0xFF & address >>> 24);
        octets[offset + 1] = (byte)(0xFF & address >>> 16);
        octets[offset + 2] = (byte)(0xFF & address >>> 8);
        octets[offset + 3] = (byte)(0xFF & address);
    }

    public static void intToOctets(int address, byte[] octets) {
        OctetConverter.intToOctets(address, octets, 0);
    }

    public static void longToOctets(long address, byte[] octets, int offset) {
        octets[offset] = (byte)(0xFFL & address >>> 56);
        octets[offset + 1] = (byte)(0xFFL & address >>> 48);
        octets[offset + 2] = (byte)(0xFFL & address >>> 40);
        octets[offset + 3] = (byte)(0xFFL & address >>> 32);
        octets[offset + 4] = (byte)(0xFFL & address >>> 24);
        octets[offset + 5] = (byte)(0xFFL & address >>> 16);
        octets[offset + 6] = (byte)(0xFFL & address >>> 8);
        octets[offset + 7] = (byte)(0xFFL & address);
    }

    public static void longToOctets(long address, byte[] octets) {
        OctetConverter.longToOctets(address, octets, 0);
    }
}

