/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

import org.savarese.vserv.tcpip.IPPacket;
import org.savarese.vserv.tcpip.OctetConverter;

public class TCPPacket
extends IPPacket {
    public static final int OFFSET_SOURCE_PORT = 0;
    public static final int OFFSET_DESTINATION_PORT = 2;
    public static final int OFFSET_SEQUENCE = 4;
    public static final int OFFSET_ACK = 8;
    public static final int OFFSET_HEADER_LENGTH = 12;
    public static final int OFFSET_CONTROL = 13;
    public static final int OFFSET_WINDOW_SIZE = 14;
    public static final int OFFSET_TCP_CHECKSUM = 16;
    public static final int OFFSET_URG_POINTER = 18;
    public static final int MASK_FIN = 1;
    public static final int MASK_SYN = 2;
    public static final int MASK_RST = 4;
    public static final int MASK_PSH = 8;
    public static final int MASK_ACK = 16;
    public static final int MASK_URG = 32;
    public static final byte KIND_EOL = 0;
    public static final byte KIND_NOP = 1;
    public static final byte KIND_SACK = 4;
    private int __offset;

    public TCPPacket(int size) {
        super(size);
        this.__offset = 0;
    }

    public TCPPacket(TCPPacket packet) {
        super(packet.size());
        this.copy(packet);
        this.__offset = packet.__offset;
    }

    public void clearSACK() {
        int offset;
        int headerLength = this.getTCPHeaderByteLength();
        if (headerLength > (offset = 20)) {
            offset += this.__offset;
            headerLength += this.__offset;
            block5: do {
                byte kind = this._data_[offset];
                switch (kind) {
                    case 1: {
                        ++offset;
                        break;
                    }
                    case 0: {
                        break block5;
                    }
                    case 4: {
                        this._data_[offset] = 1;
                        this._data_[offset + 1] = 1;
                        break block5;
                    }
                    default: {
                        offset += this._data_[offset + 1];
                    }
                }
            } while (offset < headerLength);
        }
    }

    public final void copyData(TCPPacket packet) {
        if (this._data_.length < packet._data_.length) {
            byte[] data = new byte[packet._data_.length];
            System.arraycopy(this._data_, 0, data, 0, this.getCombinedHeaderByteLength());
            this._data_ = data;
        }
        int length = packet.getTCPDataByteLength();
        System.arraycopy(packet._data_, packet.getCombinedHeaderByteLength(), this._data_, this.getCombinedHeaderByteLength(), length);
        this.setTCPDataByteLength(length);
    }

    public boolean isSet(int mask) {
        return (this._data_[this.__offset + 13] & mask) == mask;
    }

    public boolean isSetAny(int mask) {
        return (this._data_[this.__offset + 13] & mask) != 0;
    }

    public boolean isSetOnly(int mask) {
        int flags = this._data_[this.__offset + 13] & 0xFF;
        return (flags & mask) == flags;
    }

    public void addControlFlags(int mask) {
        int flags = this._data_[this.__offset + 13] & 0xFF;
        this._data_[this.__offset + 13] = (byte)((flags |= mask) & 0xFF);
    }

    public void removeControlFlags(int mask) {
        int flags = this._data_[this.__offset + 13] & 0xFF;
        flags |= mask;
        this._data_[this.__offset + 13] = (byte)((flags ^= mask) & 0xFF);
    }

    public void setControlFlags(int mask) {
        this._data_[this.__offset + 13] = (byte)(mask & 0xFF);
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this.__offset = this.getIPHeaderByteLength();
    }

    public final int getSourcePort() {
        return (this._data_[this.__offset + 0] & 0xFF) << 8 | this._data_[this.__offset + 0 + 1] & 0xFF;
    }

    public final void setSourcePort(int port) {
        this._data_[this.__offset + 0] = (byte)(port >> 8 & 0xFF);
        this._data_[this.__offset + 0 + 1] = (byte)(port & 0xFF);
    }

    public final int getDestinationPort() {
        return (this._data_[this.__offset + 2] & 0xFF) << 8 | this._data_[this.__offset + 2 + 1] & 0xFF;
    }

    public final void setDestinationPort(int port) {
        this._data_[this.__offset + 2] = (byte)(port >> 8 & 0xFF);
        this._data_[this.__offset + 2 + 1] = (byte)(port & 0xFF);
    }

    public final long getSequenceNumber() {
        return ((long)this._data_[this.__offset + 4] & 0xFFL) << 24 | ((long)this._data_[this.__offset + 4 + 1] & 0xFFL) << 16 | ((long)this._data_[this.__offset + 4 + 2] & 0xFFL) << 8 | (long)this._data_[this.__offset + 4 + 3] & 0xFFL;
    }

    public final void setSequenceNumber(long seq) {
        OctetConverter.intToOctets((int)(seq & 0xFFFFFFFFFFFFFFFFL), this._data_, this.__offset + 4);
    }

    public final long getAckNumber() {
        return ((long)this._data_[this.__offset + 8] & 0xFFL) << 24 | ((long)this._data_[this.__offset + 8 + 1] & 0xFFL) << 16 | ((long)this._data_[this.__offset + 8 + 2] & 0xFFL) << 8 | (long)this._data_[this.__offset + 8 + 3] & 0xFFL;
    }

    public final void setAckNumber(long seq) {
        OctetConverter.intToOctets((int)(seq & 0xFFFFFFFFFFFFFFFFL), this._data_, this.__offset + 8);
    }

    @Override
    public void setIPHeaderLength(int length) {
        super.setIPHeaderLength(length);
        this.__offset = this.getIPHeaderByteLength();
    }

    public final int getTCPHeaderLength() {
        return (this._data_[this.__offset + 12] & 0xF0) >> 4;
    }

    public final void setTCPHeaderLength(int length) {
        int n = this.__offset + 12;
        this._data_[n] = (byte)(this._data_[n] & 0xF);
        int n2 = this.__offset + 12;
        this._data_[n2] = (byte)(this._data_[n2] | length << 4 & 0xF0);
    }

    public final int getTCPHeaderByteLength() {
        return this.getTCPHeaderLength() << 2;
    }

    public final int getWindowSize() {
        return (this._data_[this.__offset + 14] & 0xFF) << 8 | this._data_[this.__offset + 14 + 1] & 0xFF;
    }

    public final void setWindowSize(int window) {
        this._data_[this.__offset + 14] = (byte)(window >> 8 & 0xFF);
        this._data_[this.__offset + 14 + 1] = (byte)(window & 0xFF);
    }

    public final int getUrgentPointer() {
        return (this._data_[this.__offset + 18] & 0xFF) << 8 | this._data_[this.__offset + 18 + 1] & 0xFF;
    }

    public final void setUrgentPointer(int pointer) {
        this._data_[this.__offset + 18] = (byte)(pointer >> 8 & 0xFF);
        this._data_[this.__offset + 18 + 1] = (byte)(pointer & 0xFF);
    }

    public final int getTCPChecksum() {
        return (this._data_[this.__offset + 16] & 0xFF) << 8 | this._data_[this.__offset + 16 + 1] & 0xFF;
    }

    public final int getTCPPacketByteLength() {
        return this.getIPPacketLength() - this.__offset;
    }

    public final int getCombinedHeaderByteLength() {
        return this.__offset + this.getTCPHeaderByteLength();
    }

    public final int getTCPDataByteLength() {
        return this.getIPPacketLength() - this.getCombinedHeaderByteLength();
    }

    public final void setTCPDataByteLength(int length) {
        if (length < 0) {
            length = 0;
        }
        this.setIPPacketLength(this.getCombinedHeaderByteLength() + length);
    }

    private final int __getVirtualHeaderTotal() {
        int s1 = (this._data_[12] & 0xFF) << 8 | this._data_[13] & 0xFF;
        int s2 = (this._data_[14] & 0xFF) << 8 | this._data_[15] & 0xFF;
        int d1 = (this._data_[16] & 0xFF) << 8 | this._data_[17] & 0xFF;
        int d2 = (this._data_[18] & 0xFF) << 8 | this._data_[19] & 0xFF;
        return s1 + s2 + d1 + d2 + this.getProtocol() + this.getTCPPacketByteLength();
    }

    public final int computeTCPChecksum(boolean update) {
        return this._computeChecksum_(this.__offset, this.__offset + 16, this.getIPPacketLength(), this.__getVirtualHeaderTotal(), update);
    }

    public final int computeTCPChecksum() {
        return this.computeTCPChecksum(true);
    }
}

