/*
 * Decompiled with CFR 0.152.
 */
package org.savarese.vserv.tcpip;

import org.savarese.vserv.tcpip.IPPacket;

public class UDPPacket
extends IPPacket {
    public static final int OFFSET_SOURCE_PORT = 0;
    public static final int OFFSET_DESTINATION_PORT = 2;
    public static final int OFFSET_UDP_TOTAL_LENGTH = 4;
    public static final int OFFSET_UDP_CHECKSUM = 6;
    public static final int LENGTH_UDP_HEADER = 8;
    private int __offset;

    public UDPPacket(int size) {
        super(size);
        this.__offset = 0;
    }

    public UDPPacket(UDPPacket packet) {
        super(packet.size());
        this.copy(packet);
        this.__offset = packet.__offset;
    }

    public final void copyData(UDPPacket packet) {
        if (this._data_.length < packet._data_.length) {
            byte[] data = new byte[packet._data_.length];
            System.arraycopy(this._data_, 0, data, 0, this.getCombinedHeaderByteLength());
            this._data_ = data;
        }
        int length = packet.getUDPDataByteLength();
        System.arraycopy(packet._data_, packet.getCombinedHeaderByteLength(), this._data_, this.getCombinedHeaderByteLength(), length);
        this.setUDPDataByteLength(length);
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this.__offset = this.getIPHeaderByteLength();
    }

    public final int getSourcePort() {
        return (this._data_[this.__offset + 0] & 0xFF) << 8 | this._data_[this.__offset + 0 + 1] & 0xFF;
    }

    public final void setSourcePort(int port) {
        this._data_[this.__offset + 0] = (byte)(port >> 8 & 0xFF);
        this._data_[this.__offset + 0 + 1] = (byte)(port & 0xFF);
    }

    public final int getDestinationPort() {
        return (this._data_[this.__offset + 2] & 0xFF) << 8 | this._data_[this.__offset + 2 + 1] & 0xFF;
    }

    public final void setDestinationPort(int port) {
        this._data_[this.__offset + 2] = (byte)(port >> 8 & 0xFF);
        this._data_[this.__offset + 2 + 1] = (byte)(port & 0xFF);
    }

    @Override
    public void setIPHeaderLength(int length) {
        super.setIPHeaderLength(length);
        this.__offset = this.getIPHeaderByteLength();
    }

    public final int getUDPPacketLength() {
        return (this._data_[this.__offset + 4] & 0xFF) << 8 | this._data_[this.__offset + 4 + 1] & 0xFF;
    }

    public void setUDPPacketLength(int length) {
        this._data_[this.__offset + 4] = (byte)(length >> 8 & 0xFF);
        this._data_[this.__offset + 4 + 1] = (byte)(length & 0xFF);
    }

    public final int getUDPChecksum() {
        return (this._data_[this.__offset + 6] & 0xFF) << 8 | this._data_[this.__offset + 6 + 1] & 0xFF;
    }

    public final int getUDPPacketByteLength() {
        return this.getIPPacketLength() - this.__offset;
    }

    public final int getCombinedHeaderByteLength() {
        return this.__offset + 8;
    }

    public final int getUDPDataByteLength() {
        return this.getIPPacketLength() - this.getCombinedHeaderByteLength();
    }

    public final void setUDPDataByteLength(int length) {
        if (length < 0) {
            length = 0;
        }
        this.setIPPacketLength(this.getCombinedHeaderByteLength() + length);
    }

    private final int __getVirtualHeaderTotal() {
        int s1 = (this._data_[12] & 0xFF) << 8 | this._data_[13] & 0xFF;
        int s2 = (this._data_[14] & 0xFF) << 8 | this._data_[15] & 0xFF;
        int d1 = (this._data_[16] & 0xFF) << 8 | this._data_[17] & 0xFF;
        int d2 = (this._data_[18] & 0xFF) << 8 | this._data_[19] & 0xFF;
        return s1 + s2 + d1 + d2 + this.getProtocol() + this.getUDPPacketByteLength();
    }

    public final int computeUDPChecksum(boolean update) {
        return this._computeChecksum_(this.__offset, this.__offset + 6, this.getIPPacketLength(), this.__getVirtualHeaderTotal(), update);
    }

    public final int computeUDPChecksum() {
        return this.computeUDPChecksum(true);
    }
}

