/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.filter;

import com.power.common.exception.IPException;
import com.power.common.util.IpUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpFilter
implements Filter {
    public static final String ALLOW = "allow";
    public static final String DENY = "deny";
    public static final String MSG = "msg";
    private static final Logger LOGGER = LoggerFactory.getLogger(IpFilter.class);
    private Set<String> allowSet = null;
    private Set<String> denySet = null;
    private String msg = null;

    public void init(FilterConfig fConfig) throws ServletException {
        String denyString;
        String allowString = fConfig.getInitParameter(ALLOW);
        if (allowString != null) {
            this.allowSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(allowString.split(";", 0))));
        }
        if ((denyString = fConfig.getInitParameter(DENY)) != null) {
            this.denySet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(denyString.split(";", 0))));
        }
        this.msg = fConfig.getInitParameter(MSG);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String ip = IpUtil.getIpAddress(req);
        if (null != this.denySet) {
            if (this.denySet.contains(ip)) {
                this.handleMsg(response, ip);
            } else {
                chain.doFilter(request, response);
            }
        } else if (this.allowSet != null) {
            if (this.allowSet.contains(ip)) {
                chain.doFilter(request, response);
            } else {
                this.handleMsg(response, ip);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void handleMsg(ServletResponse response, String ip) throws IOException {
        if (null == this.msg) {
            LOGGER.error("This ip can't all access [IP]: {}", (Object)ip);
            throw new IPException("This ip can't all access,IP: " + ip);
        }
        HttpServletResponse resp = (HttpServletResponse)response;
        resp.setContentType("application/json; charset=utf-8");
        resp.getWriter().println(this.msg);
    }
}

