/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.builder.impl;

import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.builder.TypeAssembler;
import com.thoughtworks.qdox.builder.impl.DefaultJavaAnnotationAssembler;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaExecutable;
import com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.expression.Expression;
import com.thoughtworks.qdox.model.impl.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.impl.DefaultJavaClass;
import com.thoughtworks.qdox.model.impl.DefaultJavaConstructor;
import com.thoughtworks.qdox.model.impl.DefaultJavaField;
import com.thoughtworks.qdox.model.impl.DefaultJavaInitializer;
import com.thoughtworks.qdox.model.impl.DefaultJavaMethod;
import com.thoughtworks.qdox.model.impl.DefaultJavaModule;
import com.thoughtworks.qdox.model.impl.DefaultJavaModuleDescriptor;
import com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameter;
import com.thoughtworks.qdox.model.impl.DefaultJavaSource;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import com.thoughtworks.qdox.model.impl.DefaultJavaTypeVariable;
import com.thoughtworks.qdox.parser.expression.ExpressionDef;
import com.thoughtworks.qdox.parser.structs.AnnoDef;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.InitDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import com.thoughtworks.qdox.parser.structs.ModuleDef;
import com.thoughtworks.qdox.parser.structs.PackageDef;
import com.thoughtworks.qdox.parser.structs.TagDef;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.parser.structs.TypeVariableDef;
import com.thoughtworks.qdox.type.TypeResolver;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ModelBuilder
implements Builder {
    private final DefaultJavaSource source;
    private DefaultJavaModule module;
    private DefaultJavaModuleDescriptor moduleDescriptor;
    private LinkedList<DefaultJavaClass> classStack = new LinkedList();
    private List<DefaultJavaParameter> parameterList = new LinkedList<DefaultJavaParameter>();
    private DefaultJavaConstructor currentConstructor;
    private DefaultJavaMethod currentMethod;
    private DefaultJavaField currentField;
    private List<AnnoDef> currentAnnoDefs;
    private List<ExpressionDef> currentArguments;
    private String lastComment;
    private List<TagDef> lastTagSet = new LinkedList<TagDef>();
    private ClassLibrary classLibrary;
    private DocletTagFactory docletTagFactory;
    private ModelWriterFactory modelWriterFactory;

    public ModelBuilder(ClassLibrary classLibrary, DocletTagFactory docletTagFactory) {
        this.classLibrary = classLibrary;
        this.docletTagFactory = docletTagFactory;
        this.source = new DefaultJavaSource(classLibrary);
        this.currentAnnoDefs = new LinkedList<AnnoDef>();
        this.currentArguments = new LinkedList<ExpressionDef>();
    }

    @Override
    public void setModelWriterFactory(ModelWriterFactory modelWriterFactory) {
        this.modelWriterFactory = modelWriterFactory;
        this.source.setModelWriterFactory(modelWriterFactory);
    }

    @Override
    public void setModule(ModuleDef moduleDef) {
        this.moduleDescriptor = new DefaultJavaModuleDescriptor(moduleDef.getName());
        this.module = new DefaultJavaModule(moduleDef.getName(), this.moduleDescriptor);
    }

    @Override
    public void addExports(ModuleDef.ExportsDef exportsDef) {
        ArrayList<JavaModule> targets = new ArrayList<JavaModule>(exportsDef.getTargets().size());
        for (String moduleName : exportsDef.getTargets()) {
            targets.add(new DefaultJavaModule(moduleName, null));
        }
        DefaultJavaModuleDescriptor.DefaultJavaExports exports = new DefaultJavaModuleDescriptor.DefaultJavaExports(new DefaultJavaPackage(exportsDef.getSource()), targets);
        exports.setLineNumber(exportsDef.getLineNumber());
        exports.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addExports(exports);
    }

    @Override
    public void addOpens(ModuleDef.OpensDef opensDef) {
        ArrayList<JavaModule> targets = new ArrayList<JavaModule>(opensDef.getTargets().size());
        for (String moduleName : opensDef.getTargets()) {
            targets.add(new DefaultJavaModule(moduleName, null));
        }
        DefaultJavaModuleDescriptor.DefaultJavaOpens exports = new DefaultJavaModuleDescriptor.DefaultJavaOpens(new DefaultJavaPackage(opensDef.getSource()), targets);
        exports.setLineNumber(opensDef.getLineNumber());
        exports.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addOpens(exports);
    }

    @Override
    public void addProvides(ModuleDef.ProvidesDef providesDef) {
        DefaultJavaType service = this.createType(providesDef.getService(), 0);
        LinkedList<JavaClass> implementations = new LinkedList<JavaClass>();
        for (TypeDef implementType : providesDef.getImplementations()) {
            implementations.add(this.createType(implementType, 0));
        }
        DefaultJavaModuleDescriptor.DefaultJavaProvides provides = new DefaultJavaModuleDescriptor.DefaultJavaProvides(service, implementations);
        provides.setLineNumber(providesDef.getLineNumber());
        provides.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addProvides(provides);
    }

    @Override
    public void addRequires(ModuleDef.RequiresDef requiresDef) {
        DefaultJavaModule module = new DefaultJavaModule(requiresDef.getName(), null);
        DefaultJavaModuleDescriptor.DefaultJavaRequires requires = new DefaultJavaModuleDescriptor.DefaultJavaRequires(module, requiresDef.getModifiers());
        requires.setLineNumber(requiresDef.getLineNumber());
        requires.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addRequires(requires);
    }

    @Override
    public void addUses(ModuleDef.UsesDef usesDef) {
        DefaultJavaModuleDescriptor.DefaultJavaUses uses = new DefaultJavaModuleDescriptor.DefaultJavaUses(this.createType(usesDef.getService(), 0));
        uses.setLineNumber(usesDef.getLineNumber());
        uses.setModelWriterFactory(this.modelWriterFactory);
        this.moduleDescriptor.addUses(uses);
    }

    @Override
    public void addPackage(PackageDef packageDef) {
        DefaultJavaPackage jPackage = new DefaultJavaPackage(packageDef.getName());
        jPackage.setClassLibrary(this.classLibrary);
        jPackage.setLineNumber(packageDef.getLineNumber());
        jPackage.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(jPackage);
        this.setAnnotations(jPackage);
        this.source.setPackage(jPackage);
    }

    @Override
    public void addImport(String importName) {
        this.source.addImport(importName);
    }

    @Override
    public void addJavaDoc(String text) {
        this.lastComment = text;
    }

    @Override
    public void addJavaDocTag(TagDef tagDef) {
        this.lastTagSet.add(tagDef);
    }

    @Override
    public void beginClass(ClassDef def) {
        DefaultJavaClass newClass = new DefaultJavaClass(this.source);
        newClass.setLineNumber(def.getLineNumber());
        newClass.setModelWriterFactory(this.modelWriterFactory);
        newClass.setName(def.getName());
        newClass.setInterface("interface".equals(def.getType()));
        newClass.setEnum("enum".equals(def.getType()));
        newClass.setAnnotation("@interface".equals(def.getType()));
        if (newClass.isInterface()) {
            newClass.setSuperClass(null);
        } else if (!newClass.isEnum()) {
            newClass.setSuperClass(def.getExtends().size() > 0 ? this.createType(def.getExtends().iterator().next(), 0) : null);
        }
        Set<TypeDef> implementSet = newClass.isInterface() ? def.getExtends() : def.getImplements();
        LinkedList<JavaClass> implementz = new LinkedList<JavaClass>();
        for (TypeDef implementType : implementSet) {
            implementz.add(this.createType(implementType, 0));
        }
        newClass.setImplementz(implementz);
        newClass.setModifiers(new LinkedList<String>(def.getModifiers()));
        if (def.getTypeParameters() != null) {
            LinkedList<DefaultJavaTypeVariable<JavaClass>> typeParams = new LinkedList<DefaultJavaTypeVariable<JavaClass>>();
            for (TypeVariableDef typeVariableDef : def.getTypeParameters()) {
                typeParams.add(this.createTypeVariable(typeVariableDef, newClass));
            }
            newClass.setTypeParameters(typeParams);
        }
        this.addJavaDoc(newClass);
        this.setAnnotations(newClass);
        this.classStack.addFirst(this.bindClass(newClass));
    }

    protected DefaultJavaClass bindClass(DefaultJavaClass newClass) {
        if (this.currentField != null) {
            this.classStack.getFirst().addClass(newClass);
            this.currentField.setEnumConstantClass(newClass);
        } else if (!this.classStack.isEmpty()) {
            this.classStack.getFirst().addClass(newClass);
            newClass.setDeclaringClass(this.classStack.getFirst());
        } else {
            this.source.addClass(newClass);
        }
        return newClass;
    }

    @Override
    public void endClass() {
        this.classStack.removeFirst();
    }

    private DefaultJavaType createType(TypeDef typeDef, int dimensions) {
        if (typeDef == null) {
            return null;
        }
        TypeResolver typeResolver = this.classStack.isEmpty() ? TypeResolver.byPackageName(this.source.getPackageName(), this.classLibrary, this.source.getImports()) : TypeResolver.byClassName(this.classStack.getFirst().getBinaryName(), this.classLibrary, this.source.getImports());
        return TypeAssembler.createUnresolved(typeDef, dimensions, typeResolver);
    }

    private void addJavaDoc(AbstractBaseJavaEntity entity) {
        entity.setComment(this.lastComment);
        LinkedList<DocletTag> tagList = new LinkedList<DocletTag>();
        for (TagDef tagDef : this.lastTagSet) {
            tagList.add(this.docletTagFactory.createDocletTag(tagDef.getName(), tagDef.getText(), (JavaAnnotatedElement)((Object)entity), tagDef.getLineNumber()));
        }
        entity.setTags(tagList);
        this.lastTagSet.clear();
        this.lastComment = null;
    }

    @Override
    public void addInitializer(InitDef def) {
        DefaultJavaInitializer initializer = new DefaultJavaInitializer();
        initializer.setLineNumber(def.getLineNumber());
        initializer.setBlock(def.getBlockContent());
        initializer.setStatic(def.isStatic());
        this.classStack.getFirst().addInitializer(initializer);
    }

    @Override
    public void beginConstructor() {
        this.currentConstructor = new DefaultJavaConstructor();
        this.currentConstructor.setDeclaringClass(this.classStack.getFirst());
        this.currentConstructor.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(this.currentConstructor);
        this.setAnnotations(this.currentConstructor);
        this.classStack.getFirst().addConstructor(this.currentConstructor);
    }

    @Override
    public void endConstructor(MethodDef def) {
        this.currentConstructor.setLineNumber(def.getLineNumber());
        this.currentConstructor.setName(def.getName());
        if (def.getTypeParams() != null) {
            LinkedList<JavaTypeVariable<JavaConstructor>> typeParams = new LinkedList<JavaTypeVariable<JavaConstructor>>();
            for (TypeVariableDef typeVariableDef : def.getTypeParams()) {
                typeParams.add(this.createTypeVariable(typeVariableDef, this.currentConstructor));
            }
            this.currentConstructor.setTypeParameters(typeParams);
        }
        LinkedList<JavaClass> exceptions = new LinkedList<JavaClass>();
        for (TypeDef type : def.getExceptions()) {
            exceptions.add(this.createType(type, 0));
        }
        this.currentConstructor.setExceptions(exceptions);
        this.currentConstructor.setModifiers(new LinkedList<String>(def.getModifiers()));
        if (!this.parameterList.isEmpty()) {
            this.currentConstructor.setParameters(new ArrayList<JavaParameter>(this.parameterList));
            this.parameterList.clear();
        }
        this.currentConstructor.setSourceCode(def.getBody());
    }

    @Override
    public void beginMethod() {
        this.currentMethod = new DefaultJavaMethod();
        if (this.currentField == null) {
            this.currentMethod.setDeclaringClass(this.classStack.getFirst());
            this.classStack.getFirst().addMethod(this.currentMethod);
        }
        this.currentMethod.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(this.currentMethod);
        this.setAnnotations(this.currentMethod);
    }

    @Override
    public void endMethod(MethodDef def) {
        this.currentMethod.setLineNumber(def.getLineNumber());
        this.currentMethod.setName(def.getName());
        this.currentMethod.setReturns(this.createType(def.getReturnType(), def.getDimensions()));
        if (def.getTypeParams() != null) {
            LinkedList<JavaTypeVariable<JavaMethod>> typeParams = new LinkedList<JavaTypeVariable<JavaMethod>>();
            for (TypeVariableDef typeVariableDef : def.getTypeParams()) {
                typeParams.add(this.createTypeVariable(typeVariableDef, this.currentMethod));
            }
            this.currentMethod.setTypeParameters(typeParams);
        }
        LinkedList<JavaClass> exceptions = new LinkedList<JavaClass>();
        for (TypeDef type : def.getExceptions()) {
            exceptions.add(this.createType(type, 0));
        }
        this.currentMethod.setExceptions(exceptions);
        this.currentMethod.setDefault(def.getModifiers().remove("default"));
        this.currentMethod.setModifiers(new LinkedList<String>(def.getModifiers()));
        if (!this.parameterList.isEmpty()) {
            this.currentMethod.setParameters(new ArrayList<JavaParameter>(this.parameterList));
            this.parameterList.clear();
        }
        this.currentMethod.setSourceCode(def.getBody());
    }

    private <G extends JavaGenericDeclaration> DefaultJavaTypeVariable<G> createTypeVariable(TypeVariableDef typeVariableDef, G genericDeclaration) {
        if (typeVariableDef == null) {
            return null;
        }
        JavaClass declaringClass = ModelBuilder.getContext(genericDeclaration);
        if (declaringClass == null) {
            return null;
        }
        TypeResolver typeResolver = TypeResolver.byClassName(declaringClass.getBinaryName(), this.classLibrary, this.source.getImports());
        DefaultJavaTypeVariable result = new DefaultJavaTypeVariable(typeVariableDef.getName(), typeResolver);
        if (typeVariableDef.getBounds() != null && !typeVariableDef.getBounds().isEmpty()) {
            LinkedList<JavaType> bounds = new LinkedList<JavaType>();
            for (TypeDef typeDef : typeVariableDef.getBounds()) {
                bounds.add(this.createType(typeDef, 0));
            }
            result.setBounds(bounds);
        }
        return result;
    }

    private static JavaClass getContext(JavaGenericDeclaration genericDeclaration) {
        JavaClass result;
        if (genericDeclaration instanceof JavaClass) {
            result = (JavaClass)genericDeclaration;
        } else if (genericDeclaration instanceof JavaExecutable) {
            result = ((JavaExecutable)genericDeclaration).getDeclaringClass();
        } else {
            throw new IllegalArgumentException("Unknown JavaGenericDeclaration implementation");
        }
        return result;
    }

    @Override
    public void beginField(FieldDef def) {
        this.currentField = new DefaultJavaField(def.getName());
        this.currentField.setDeclaringClass(this.classStack.getFirst());
        this.currentField.setLineNumber(def.getLineNumber());
        this.currentField.setModelWriterFactory(this.modelWriterFactory);
        this.currentField.setType(this.createType(def.getType(), def.getDimensions()));
        this.currentField.setEnumConstant(def.isEnumConstant());
        this.currentField.setModifiers(new LinkedList<String>(def.getModifiers()));
        this.currentField.setInitializationExpression(def.getBody());
        this.addJavaDoc(this.currentField);
        this.setAnnotations(this.currentField);
    }

    @Override
    public void setFieldInitializationExpression(String expression) {
        this.currentField.setInitializationExpression(expression);
    }

    @Override
    public void endField() {
        if (this.currentArguments != null && !this.currentArguments.isEmpty()) {
            TypeResolver typeResolver = this.classStack.isEmpty() ? TypeResolver.byPackageName(this.source.getPackageName(), this.classLibrary, this.source.getImports()) : TypeResolver.byClassName(this.classStack.getFirst().getBinaryName(), this.classLibrary, this.source.getImports());
            DefaultJavaAnnotationAssembler assembler = new DefaultJavaAnnotationAssembler(this.currentField.getDeclaringClass(), this.classLibrary, typeResolver);
            LinkedList<Expression> arguments = new LinkedList<Expression>();
            for (ExpressionDef annoDef : this.currentArguments) {
                arguments.add(assembler.assemble(annoDef));
            }
            this.currentField.setEnumConstantArguments(arguments);
            this.currentArguments.clear();
        }
        this.classStack.getFirst().addField(this.currentField);
        this.currentField = null;
    }

    @Override
    public void addParameter(FieldDef fieldDef) {
        DefaultJavaParameter jParam = new DefaultJavaParameter(this.createType(fieldDef.getType(), fieldDef.getDimensions()), fieldDef.getName(), fieldDef.isVarArgs());
        if (this.currentMethod != null) {
            jParam.setExecutable(this.currentMethod);
        } else {
            jParam.setExecutable(this.currentConstructor);
        }
        jParam.setModelWriterFactory(this.modelWriterFactory);
        this.addJavaDoc(jParam);
        this.setAnnotations(jParam);
        this.parameterList.add(jParam);
    }

    private void setAnnotations(AbstractBaseJavaEntity entity) {
        if (!this.currentAnnoDefs.isEmpty()) {
            TypeResolver typeResolver = this.classStack.isEmpty() ? TypeResolver.byPackageName(this.source.getPackageName(), this.classLibrary, this.source.getImports()) : TypeResolver.byClassName(this.classStack.getFirst().getBinaryName(), this.classLibrary, this.source.getImports());
            DefaultJavaAnnotationAssembler assembler = new DefaultJavaAnnotationAssembler(entity.getDeclaringClass(), this.classLibrary, typeResolver);
            LinkedList<JavaAnnotation> annotations = new LinkedList<JavaAnnotation>();
            for (AnnoDef annoDef : this.currentAnnoDefs) {
                annotations.add(assembler.assemble(annoDef));
            }
            entity.setAnnotations(annotations);
            this.currentAnnoDefs.clear();
        }
    }

    @Override
    public void addAnnotation(AnnoDef annotation) {
        this.currentAnnoDefs.add(annotation);
    }

    @Override
    public void addArgument(ExpressionDef argument) {
        this.currentArguments.add(argument);
    }

    @Override
    public JavaSource getSource() {
        return this.source;
    }

    @Override
    public JavaModule getModuleInfo() {
        return this.module;
    }

    @Override
    public void setUrl(URL url) {
        this.source.setURL(url);
    }
}

