/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.RandomUtil;
import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.common.util.ValidateUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.handler.JaxrsHeaderHandler;
import com.power.doc.handler.JaxrsPathHandler;
import com.power.doc.helper.FormDataBuildHelper;
import com.power.doc.helper.JsonBuildHelper;
import com.power.doc.helper.ParamsBuildHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiMethodReqParam;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.model.DocJavaParameter;
import com.power.doc.model.FormData;
import com.power.doc.model.annotation.EntryAnnotation;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.model.annotation.HeaderAnnotation;
import com.power.doc.model.request.ApiRequestExample;
import com.power.doc.model.request.CurlRequest;
import com.power.doc.model.request.JaxrsPathMapping;
import com.power.doc.model.request.RequestMapping;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.template.IRestDocTemplate;
import com.power.doc.utils.ApiParamTreeUtil;
import com.power.doc.utils.CurlUtil;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocPathUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.power.doc.utils.JsonUtil;
import com.power.doc.utils.TornaUtil;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JaxrsDocBuildTemplate
implements IDocBuildTemplate<ApiDoc>,
IRestDocTemplate {
    private static final Logger log = Logger.getLogger(JaxrsDocBuildTemplate.class.getName());
    private final AtomicInteger atomicInteger = new AtomicInteger(1);
    private List<ApiReqParam> headers;

    @Override
    public List<ApiDoc> getApiData(ProjectDocConfigBuilder projectBuilder) {
        ApiConfig apiConfig = projectBuilder.getApiConfig();
        FrameworkAnnotations frameworkAnnotations = this.registeredAnnotations();
        this.headers = apiConfig.getRequestHeaders();
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        int order = 0;
        Collection classes = projectBuilder.getJavaProjectBuilder().getClasses();
        boolean setCustomOrder = false;
        for (JavaClass cls : classes) {
            if (StringUtil.isNotEmpty((String)apiConfig.getPackageFilters()) && !DocUtil.isMatch(apiConfig.getPackageFilters(), cls.getCanonicalName())) continue;
            DocletTag ignoreTag = cls.getTagByName("ignore");
            if (!this.isEntryPoint(cls, frameworkAnnotations) || Objects.nonNull(ignoreTag)) continue;
            String strOrder = JavaClassUtil.getClassTagsValue(cls, "order", Boolean.TRUE);
            ++order;
            if (ValidateUtil.isNonNegativeInteger((String)strOrder)) {
                setCustomOrder = true;
                order = Integer.parseInt(strOrder);
            }
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls, apiConfig, projectBuilder, frameworkAnnotations);
            this.handleApiDoc(cls, apiDocList, apiMethodDocs, order, apiConfig.isMd5EncryptedHtmlName());
        }
        if (apiConfig.isSortByTitle()) {
            Collections.sort(apiDocList);
        } else if (setCustomOrder) {
            return apiDocList.stream().sorted(Comparator.comparing(ApiDoc::getOrder)).peek(p -> p.setOrder(this.atomicInteger.getAndAdd(1))).collect(Collectors.toList());
        }
        return apiDocList;
    }

    private List<ApiMethodDoc> buildControllerMethod(JavaClass cls, ApiConfig apiConfig, ProjectDocConfigBuilder projectBuilder, FrameworkAnnotations frameworkAnnotations) {
        String clzName = cls.getCanonicalName();
        boolean paramsDataToTree = projectBuilder.getApiConfig().isParamsDataToTree();
        String group = JavaClassUtil.getClassTagsValue(cls, "group", Boolean.TRUE);
        String baseUrl = "";
        String mediaType = null;
        List<JavaAnnotation> classAnnotations = this.getClassAnnotations(cls, frameworkAnnotations);
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getFullyQualifiedName();
            if ("jakarta.ws.rs.Path".equals(annotationName) || "javax.ws.rs.Path".equals(annotationName)) {
                baseUrl = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(annotation));
            }
            mediaType = DocUtil.handleContentType(mediaType, annotation, annotationName);
        }
        List methods = cls.getMethods();
        ArrayList<DocJavaMethod> docJavaMethods = new ArrayList<DocJavaMethod>(methods.size());
        for (JavaMethod method : methods) {
            if (method.isPrivate()) continue;
            docJavaMethods.add(this.convertToDocJavaMethod(apiConfig, projectBuilder, method, null));
        }
        docJavaMethods.addAll(this.getParenClassMethods(apiConfig, projectBuilder, cls));
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        int methodOrder = 0;
        for (DocJavaMethod docJavaMethod : docJavaMethods) {
            JaxrsPathMapping jaxPathMapping;
            JavaMethod method = docJavaMethod.getJavaMethod();
            if (this.checkCondition(method) || Objects.isNull(jaxPathMapping = new JaxrsPathHandler().handle(projectBuilder, baseUrl, method, mediaType))) continue;
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setDownload(docJavaMethod.isDownload());
            apiMethodDoc.setPage(docJavaMethod.getPage());
            apiMethodDoc.setGroup(group);
            if (Objects.nonNull(docJavaMethod.getGroup())) {
                apiMethodDoc.setGroup(docJavaMethod.getGroup());
            }
            apiMethodDoc.setName(method.getName());
            apiMethodDoc.setOrder(++methodOrder);
            apiMethodDoc.setDesc(docJavaMethod.getDesc());
            String methodUid = DocUtil.generateId(clzName + method.getName() + methodOrder);
            apiMethodDoc.setMethodId(methodUid);
            apiMethodDoc.setAuthor(docJavaMethod.getAuthor());
            apiMethodDoc.setDetail(docJavaMethod.getDetail());
            List<ApiReqParam> ApiReqParams = new JaxrsHeaderHandler().handle(method, projectBuilder);
            apiMethodDoc.setType(jaxPathMapping.getMethodType());
            apiMethodDoc.setUrl(jaxPathMapping.getUrl());
            apiMethodDoc.setServerUrl(projectBuilder.getServerUrl());
            apiMethodDoc.setPath(jaxPathMapping.getShortUrl());
            apiMethodDoc.setDeprecated(jaxPathMapping.isDeprecated());
            apiMethodDoc.setContentType(jaxPathMapping.getMediaType());
            ApiMethodReqParam apiMethodReqParam = this.requestParams(docJavaMethod, projectBuilder);
            apiMethodDoc.setPathParams(apiMethodReqParam.getPathParams());
            apiMethodDoc.setQueryParams(apiMethodReqParam.getQueryParams());
            apiMethodDoc.setRequestParams(apiMethodReqParam.getRequestParams());
            if (paramsDataToTree) {
                this.convertParamsDataToTree(apiMethodDoc);
            }
            List<ApiReqParam> allApiReqParams = ApiReqParams;
            if (this.headers != null) {
                allApiReqParams = Stream.of(this.headers, ApiReqParams).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            allApiReqParams.removeIf(ApiReqParam2 -> {
                if (StringUtil.isEmpty((String)ApiReqParam2.getPathPatterns()) && StringUtil.isEmpty((String)ApiReqParam2.getExcludePathPatterns())) {
                    return false;
                }
                boolean flag = DocPathUtil.matches(jaxPathMapping.getShortUrl(), ApiReqParam2.getPathPatterns(), ApiReqParam2.getExcludePathPatterns());
                return !flag;
            });
            apiMethodDoc.setHeaders(this.createDocRenderHeaders(allApiReqParams, apiConfig.isAdoc()));
            apiMethodDoc.setRequestHeaders(allApiReqParams);
            ApiRequestExample requestExample = this.buildReqJson(docJavaMethod, apiMethodDoc, jaxPathMapping.getMethodType(), projectBuilder);
            String requestJson = requestExample.getExampleBody();
            apiMethodDoc.setRequestExample(requestExample);
            apiMethodDoc.setRequestUsage(requestJson == null ? requestExample.getUrl() : requestJson);
            String responseValue = DocUtil.getNormalTagComments(method, "response", cls.getName());
            if (StringUtil.isNotEmpty((String)responseValue)) {
                apiMethodDoc.setResponseUsage(responseValue);
            } else {
                apiMethodDoc.setResponseUsage(JsonBuildHelper.buildReturnJson(docJavaMethod, projectBuilder));
            }
            List<ApiParam> responseParams = this.buildReturnApiParams(docJavaMethod, projectBuilder);
            if (paramsDataToTree) {
                responseParams = ApiParamTreeUtil.apiParamToTree(responseParams);
            }
            apiMethodDoc.setReturnSchema(docJavaMethod.getReturnSchema());
            apiMethodDoc.setRequestSchema(docJavaMethod.getRequestSchema());
            apiMethodDoc.setResponseParams(responseParams);
            methodDocList.add(apiMethodDoc);
            TornaUtil.setTornaArrayTags(docJavaMethod.getJavaMethod(), apiMethodDoc);
        }
        return methodDocList;
    }

    @Override
    public FrameworkAnnotations registeredAnnotations() {
        FrameworkAnnotations annotations = FrameworkAnnotations.builder();
        HeaderAnnotation headerAnnotation = HeaderAnnotation.builder().setAnnotationName("javax.ws.rs.HeaderParam").setValueProp("value").setDefaultValueProp("defaultValue").setRequiredProp("required");
        annotations.setHeaderAnnotation(headerAnnotation);
        HashMap<String, EntryAnnotation> entryAnnotations = new HashMap<String, EntryAnnotation>();
        EntryAnnotation jakartaPathAnnotation = EntryAnnotation.builder().setAnnotationName("jakarta.ws.rs.Path").setAnnotationFullyName("jakarta.ws.rs.Path");
        entryAnnotations.put(jakartaPathAnnotation.getAnnotationName(), jakartaPathAnnotation);
        EntryAnnotation jaxPathAnnotation = EntryAnnotation.builder().setAnnotationName("javax.ws.rs.Path").setAnnotationFullyName("javax.ws.rs.Path");
        entryAnnotations.put(jaxPathAnnotation.getAnnotationName(), jaxPathAnnotation);
        annotations.setEntryAnnotations(entryAnnotations);
        return annotations;
    }

    @Override
    public boolean isEntryPoint(JavaClass cls, FrameworkAnnotations frameworkAnnotations) {
        if (cls.isAnnotation() || cls.isEnum()) {
            return false;
        }
        List<JavaAnnotation> classAnnotations = DocClassUtil.getAnnotations(cls);
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getFullyQualifiedName();
            if (!"jakarta.ws.rs.Path".equals(annotationName) && !"javax.ws.rs.Path".equals(annotationName)) continue;
            return true;
        }
        List docletTags = cls.getTags();
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getName();
            if (!"dubboRest".equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> listMvcRequestAnnotations() {
        return null;
    }

    private ApiMethodReqParam requestParams(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder) {
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        List<DocJavaParameter> parameterList = this.getJavaParameterList(builder, docJavaMethod, null);
        if (parameterList.isEmpty()) {
            return ApiMethodReqParam.builder().setPathParams(new ArrayList<ApiParam>(0)).setQueryParams(paramList).setRequestParams(new ArrayList<ApiParam>(0));
        }
        boolean isStrict = builder.getApiConfig().isStrict();
        JavaMethod javaMethod = docJavaMethod.getJavaMethod();
        String className = javaMethod.getDeclaringClass().getCanonicalName();
        Map<String, String> paramTagMap = docJavaMethod.getParamTagMap();
        Map<String, String> paramsComments = docJavaMethod.getParamsComments();
        Map<String, String> constantsMap = builder.getConstantsMap();
        boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
        Set<String> ignoreSets = this.ignoreParamsSets(javaMethod);
        block0: for (DocJavaParameter apiParameter : parameterList) {
            ApiParam param;
            String[] gicNameArr;
            boolean queryParam;
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            if (ignoreSets.contains(paramName)) continue;
            String typeName = apiParameter.getGenericCanonicalName();
            String simpleName = apiParameter.getTypeValue().toLowerCase();
            String fullTypeName = apiParameter.getFullyQualifiedName();
            String simpleTypeName = apiParameter.getTypeValue();
            if (!paramTagMap.containsKey(paramName) && JavaClassValidateUtil.isPrimitive(fullTypeName) && isStrict) {
                throw new RuntimeException("ERROR: Unable to find javadoc @QueryParam for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
            }
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, typeName, simpleTypeName);
            JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(fullTypeName);
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, builder.getJavaProjectBuilder());
            StringBuilder comment = new StringBuilder(this.paramCommentResolve(paramTagMap.get(paramName)));
            boolean isPathVariable = false;
            boolean isRequestBody = false;
            String strRequired = "false";
            if (CollectionUtil.isNotEmpty((Collection)annotations)) {
                for (JavaAnnotation annotation : annotations) {
                    String annotationName = annotation.getType().getFullyQualifiedName();
                    if ("jakarta.ws.rs.HeaderParam".equals(annotationName) || "javax.ws.rs.HeaderParam".equals(annotationName)) continue block0;
                    if ("jakarta.ws.rs.DefaultValue".equals(annotationName) || "javax.ws.rs.DefaultValue".equals(annotationName)) {
                        mockValue = StringUtil.removeQuotes((String)DocUtil.getRequestHeaderValue(annotation));
                        mockValue = DocUtil.handleConstants(constantsMap, mockValue);
                    }
                    if ("jakarta.ws.rs.PathParam".equals(annotationName) || "org.jboss.resteasy.reactive.RestPath".equals(annotationName) || "javax.ws.rs.PathParam".equals(annotationName)) {
                        isPathVariable = true;
                        strRequired = "true";
                    }
                    if (!JavaClassValidateUtil.isJSR303Required(annotation.getType().getValue())) continue;
                    strRequired = "true";
                }
                comment.append(JavaFieldUtil.getJsrComment(annotations));
            } else {
                isRequestBody = true;
            }
            boolean required = Boolean.parseBoolean(strRequired);
            boolean bl = queryParam = !isRequestBody && !isPathVariable;
            if (JavaClassValidateUtil.isCollection(fullTypeName) || JavaClassValidateUtil.isArray(fullTypeName)) {
                ApiParam param2;
                JavaClass gicJavaClass;
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                String gicName = gicNameArr[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                if ((gicJavaClass = builder.getJavaProjectBuilder().getClassByName(gicName)).isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(gicJavaClass, Boolean.TRUE);
                    param2 = ApiParam.of().setField(paramName).setDesc(comment + ",[array of enum]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(String.valueOf(value));
                    paramList.add(param2);
                    continue;
                }
                if (JavaClassValidateUtil.isPrimitive(gicName)) {
                    String shortSimple = DocClassUtil.processTypeNameForParams(gicName);
                    param2 = ApiParam.of().setField(paramName).setDesc(comment + ",[array of " + shortSimple + "]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(paramList.size() + 1).setType("array").setValue(DocUtil.getValByTypeAndFieldName(gicName, paramName));
                    paramList.add(param2);
                    continue;
                }
                int id = paramList.size() + 1;
                param2 = ApiParam.of().setField(paramName).setDesc(comment + ",[array of object]").setRequired(required).setPathParam(isPathVariable).setQueryParam(queryParam).setId(id).setType("array");
                paramList.add(param2);
                List<ApiParam> apiParamList = ParamsBuildHelper.buildParams(typeName, "\u2514\u2500", 1, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, id, Boolean.FALSE, null);
                paramList.addAll(apiParamList);
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(fullTypeName)) {
                param = ApiParam.of().setField(paramName).setType(DocClassUtil.processTypeNameForParams(simpleName)).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(mockValue).setDesc(comment.toString()).setRequired(required).setVersion("-");
                paramList.add(param);
                continue;
            }
            if (JavaClassValidateUtil.isMap(fullTypeName)) {
                log.warning("When using smart-doc, it is not recommended to use Map to receive parameters, Check it in " + javaMethod.getDeclaringClass().getCanonicalName() + "#" + javaMethod.getName());
                if (JavaClassValidateUtil.isMap(typeName)) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                if (JavaClassValidateUtil.isPrimitive(gicNameArr[1])) {
                    ApiParam apiParam = ApiParam.of().setField(paramName).setType("map").setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setDesc(comment.toString()).setRequired(required).setVersion("-");
                    paramList.add(apiParam);
                    continue;
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicNameArr[1], "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, null));
                continue;
            }
            if (JavaClassValidateUtil.isFile(typeName)) {
                param = ApiParam.of().setField(paramName).setType("file").setId(paramList.size() + 1).setQueryParam(true).setRequired(required).setVersion("-").setDesc(comment.toString());
                if (typeName.contains("[]") || typeName.endsWith(">")) {
                    comment.append("(array of file)");
                    param.setDesc(comment.toString());
                    param.setHasItems(true);
                }
                paramList.add(param);
                continue;
            }
            if (javaClass.isEnum()) {
                String o = JavaClassUtil.getEnumParams(javaClass);
                Object value = JavaClassUtil.getEnumValue(javaClass, true);
                ApiParam param3 = ApiParam.of().setField(paramName).setId(paramList.size() + 1).setPathParam(isPathVariable).setQueryParam(queryParam).setValue(String.valueOf(value)).setType("enum").setDesc(StringUtil.removeQuotes((String)o)).setRequired(required).setVersion("-").setEnumValues(JavaClassUtil.getEnumValues(javaClass));
                paramList.add(param3);
                continue;
            }
            paramList.addAll(ParamsBuildHelper.buildParams(typeName, "", 0, "true", Boolean.FALSE, new HashMap<String, String>(), builder, groupClasses, 0, Boolean.FALSE, null));
        }
        ArrayList<ApiParam> pathParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> queryParams = new ArrayList<ApiParam>();
        ArrayList<ApiParam> bodyParams = new ArrayList<ApiParam>();
        for (ApiParam param : paramList) {
            param.setValue(StringUtil.removeDoubleQuotes((String)param.getValue()));
            if (param.isPathParam()) {
                param.setId(pathParams.size() + 1);
                pathParams.add(param);
                continue;
            }
            if (param.isQueryParam()) {
                param.setId(queryParams.size() + 1);
                queryParams.add(param);
                continue;
            }
            param.setId(bodyParams.size() + 1);
            bodyParams.add(param);
        }
        return ApiMethodReqParam.builder().setRequestParams(bodyParams).setPathParams(pathParams).setQueryParams(queryParams);
    }

    private ApiRequestExample buildReqJson(DocJavaMethod javaMethod, ApiMethodDoc apiMethodDoc, String methodType, ProjectDocConfigBuilder configBuilder) {
        String exampleBody;
        CurlRequest curlRequest;
        String url;
        JavaMethod method = javaMethod.getJavaMethod();
        LinkedHashMap<String, String> pathParamsMap = new LinkedHashMap<String, String>();
        List<DocJavaParameter> parameterList = this.getJavaParameterList(configBuilder, javaMethod, null);
        List<ApiReqParam> reqHeaderList = apiMethodDoc.getRequestHeaders();
        if (parameterList.isEmpty()) {
            CurlRequest curlRequest2 = CurlRequest.builder().setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(apiMethodDoc.getUrl());
            String format = CurlUtil.toCurl(curlRequest2);
            return ApiRequestExample.builder().setUrl(apiMethodDoc.getUrl()).setExampleBody(format);
        }
        boolean requestFieldToUnderline = configBuilder.getApiConfig().isRequestFieldToUnderline();
        Map<String, String> paramsComments = javaMethod.getParamsComments();
        ArrayList<FormData> formDataList = new ArrayList<FormData>();
        ApiRequestExample requestExample = ApiRequestExample.builder();
        for (DocJavaParameter apiParameter : parameterList) {
            JavaParameter parameter = apiParameter.getJavaParameter();
            String paramName = parameter.getName();
            String typeName = apiParameter.getFullyQualifiedName();
            String gicTypeName = apiParameter.getGenericCanonicalName();
            String simpleTypeName = apiParameter.getTypeValue();
            gicTypeName = DocClassUtil.rewriteRequestParam(gicTypeName);
            JavaClass javaClass = configBuilder.getJavaProjectBuilder().getClassByName(typeName);
            String[] globGicName = DocClassUtil.getSimpleGicName(gicTypeName);
            String comment = this.paramCommentResolve(paramsComments.get(paramName));
            String mockValue = JavaFieldUtil.createMockValue(paramsComments, paramName, gicTypeName, simpleTypeName);
            if (requestFieldToUnderline) {
                paramName = StringUtil.camelToUnderline((String)paramName);
            }
            List annotations = parameter.getAnnotations();
            Set<String> groupClasses = JavaClassUtil.getParamGroupJavaClass(annotations, configBuilder.getJavaProjectBuilder());
            boolean paramAdded = false;
            if (CollectionUtil.isNotEmpty((Collection)annotations)) {
                for (JavaAnnotation annotation : annotations) {
                    FormData formData;
                    Object value;
                    String annotationName = annotation.getType().getFullyQualifiedName();
                    if ("jakarta.ws.rs.PathParam".equals(annotationName) || "org.jboss.resteasy.reactive.RestPath".equals(annotationName) || "javax.ws.rs.PathParam".equals(annotationName)) {
                        if (javaClass.isEnum()) {
                            value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                            mockValue = StringUtil.removeQuotes((String)String.valueOf(value));
                        }
                        pathParamsMap.put(paramName, mockValue);
                        paramAdded = true;
                    }
                    if (paramAdded) continue;
                    if (JavaClassValidateUtil.isFile(gicTypeName)) {
                        apiMethodDoc.setContentType("multipart/form-data");
                        formData = new FormData();
                        formData.setKey(paramName);
                        formData.setType("file");
                        formData.setDescription(comment);
                        formData.setValue(mockValue);
                        formDataList.add(formData);
                        continue;
                    }
                    if (JavaClassValidateUtil.isPrimitive(typeName)) {
                        formData = new FormData();
                        formData.setKey(paramName);
                        formData.setDescription(comment);
                        formData.setType("text");
                        formData.setValue(mockValue);
                        formDataList.add(formData);
                        continue;
                    }
                    if (JavaClassValidateUtil.isArray(typeName) || JavaClassValidateUtil.isCollection(typeName)) {
                        String gicName = globGicName[0];
                        if (JavaClassValidateUtil.isArray(gicName)) {
                            gicName = gicName.substring(0, gicName.indexOf("["));
                        }
                        if (!JavaClassValidateUtil.isPrimitive(gicName) && !configBuilder.getJavaProjectBuilder().getClassByName(gicName).isEnum()) {
                            throw new RuntimeException("Jaxrs rest can't support binding Collection on method " + method.getName() + "Check it in " + method.getDeclaringClass().getCanonicalName());
                        }
                        FormData formData2 = new FormData();
                        formData2.setKey(paramName);
                        if (!paramName.contains("[]")) {
                            formData2.setKey(paramName + "[]");
                        }
                        formData2.setDescription(comment);
                        formData2.setType("text");
                        formData2.setValue(RandomUtil.randomValueByType((String)gicName));
                        formDataList.add(formData2);
                        continue;
                    }
                    if (javaClass.isEnum()) {
                        value = JavaClassUtil.getEnumValue(javaClass, Boolean.TRUE);
                        String strVal = StringUtil.removeQuotes((String)String.valueOf(value));
                        FormData formData3 = new FormData();
                        formData3.setDescription(comment);
                        formData3.setKey(paramName);
                        formData3.setType("text");
                        formData3.setValue(strVal);
                        formDataList.add(formData3);
                        continue;
                    }
                    formDataList.addAll(FormDataBuildHelper.getFormData(gicTypeName, new HashMap<String, String>(), 0, configBuilder, ""));
                }
                continue;
            }
            if (JavaClassValidateUtil.isPrimitive(simpleTypeName)) {
                requestExample.setJsonBody(mockValue).setJson(true);
                continue;
            }
            String json = JsonBuildHelper.buildJson(typeName, gicTypeName, Boolean.FALSE, 0, new HashMap<String, String>(), groupClasses, configBuilder);
            requestExample.setJsonBody(JsonUtil.toPrettyFormat(json)).setJson(true);
        }
        requestExample.setFormDataList(formDataList);
        String[] paths = apiMethodDoc.getPath().split(";");
        String path = paths[0];
        if ("POST".equals(methodType) || "PUT".equals(methodType)) {
            path = DocUtil.formatAndRemove(path, pathParamsMap);
            String body = UrlUtil.urlJoin((String)"", DocUtil.formDataToMap(formDataList)).replace("?", "");
            body = StringUtil.removeQuotes((String)body);
            url = apiMethodDoc.getServerUrl() + "/" + path;
            url = UrlUtil.simplifyUrl((String)url);
            if (requestExample.isJson()) {
                if (StringUtil.isNotEmpty((String)body)) {
                    url = url + "?" + body;
                }
                curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            } else {
                curlRequest = StringUtil.isNotEmpty((String)body) ? CurlRequest.builder().setBody(body).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url) : CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
                exampleBody = CurlUtil.toCurl(curlRequest);
            }
            requestExample.setExampleBody(exampleBody).setUrl(url);
        } else {
            url = this.formatRequestUrl(pathParamsMap, pathParamsMap, apiMethodDoc.getServerUrl(), path);
            curlRequest = CurlRequest.builder().setBody(requestExample.getJsonBody()).setContentType(apiMethodDoc.getContentType()).setType(methodType).setReqHeaders(reqHeaderList).setUrl(url);
            exampleBody = CurlUtil.toCurl(curlRequest);
            requestExample.setExampleBody(exampleBody).setJsonBody("").setUrl(url);
        }
        return requestExample;
    }

    private boolean checkCondition(JavaMethod method) {
        return method.isPrivate() || Objects.nonNull(method.getTagByName("ignore"));
    }

    @Override
    public void requestMappingPostProcess(JavaClass javaClass, JavaMethod method, RequestMapping requestMapping) {
    }

    @Override
    public boolean ignoreMvcParamWithAnnotation(String annotation) {
        return false;
    }

    @Override
    public boolean ignoreReturnObject(String typeName, List<String> ignoreParams) {
        return false;
    }
}

