/*
 * Decompiled with CFR 0.152.
 */
package com.github.wtekiela.opensub4j.impl;

import com.github.wtekiela.opensub4j.api.FileHashCalculator;
import com.github.wtekiela.opensub4j.api.OpenSubtitlesClient;
import com.github.wtekiela.opensub4j.impl.DownloadSubtitlesOperation;
import com.github.wtekiela.opensub4j.impl.ImdbSearchOperation;
import com.github.wtekiela.opensub4j.impl.LogInOperation;
import com.github.wtekiela.opensub4j.impl.LogOutOperation;
import com.github.wtekiela.opensub4j.impl.NoopOperation;
import com.github.wtekiela.opensub4j.impl.OpenSubtitlesFileHashCalculator;
import com.github.wtekiela.opensub4j.impl.ResponseParser;
import com.github.wtekiela.opensub4j.impl.SearchOperation;
import com.github.wtekiela.opensub4j.impl.ServerInfoOperation;
import com.github.wtekiela.opensub4j.response.LoginToken;
import com.github.wtekiela.opensub4j.response.MovieInfo;
import com.github.wtekiela.opensub4j.response.Response;
import com.github.wtekiela.opensub4j.response.ResponseStatus;
import com.github.wtekiela.opensub4j.response.ServerInfo;
import com.github.wtekiela.opensub4j.response.SubtitleFile;
import com.github.wtekiela.opensub4j.response.SubtitleInfo;
import com.github.wtekiela.opensub4j.xmlrpc.client.RetriableXmlRpcClient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class OpenSubtitlesClientImpl
implements OpenSubtitlesClient {
    private final XmlRpcClient xmlRpcClient;
    private final ResponseParser responseParser;
    private final FileHashCalculator fileHashCalculator;
    private LoginToken loginToken;

    public OpenSubtitlesClientImpl(URL serverUrl) {
        XmlRpcClientConfigImpl xmlRpcClientConfig = new XmlRpcClientConfigImpl();
        xmlRpcClientConfig.setServerURL(serverUrl);
        this.xmlRpcClient = new RetriableXmlRpcClient((XmlRpcClientConfig)xmlRpcClientConfig);
        this.responseParser = new ResponseParser();
        this.fileHashCalculator = new OpenSubtitlesFileHashCalculator();
    }

    public OpenSubtitlesClientImpl(URL serverUrl, int maxAttempts, int interval) {
        XmlRpcClientConfigImpl xmlRpcClientConfig = new XmlRpcClientConfigImpl();
        xmlRpcClientConfig.setServerURL(serverUrl);
        this.xmlRpcClient = new RetriableXmlRpcClient((XmlRpcClientConfig)xmlRpcClientConfig, maxAttempts, interval);
        this.responseParser = new ResponseParser();
        this.fileHashCalculator = new OpenSubtitlesFileHashCalculator();
    }

    public OpenSubtitlesClientImpl(XmlRpcClientConfig xmlRpcClientConfig) {
        this(new RetriableXmlRpcClient(xmlRpcClientConfig), new ResponseParser(), new OpenSubtitlesFileHashCalculator());
    }

    public OpenSubtitlesClientImpl(XmlRpcClientConfig xmlRpcClientConfig, int maxAttempts, int interval) {
        this(new RetriableXmlRpcClient(xmlRpcClientConfig, maxAttempts, interval), new ResponseParser(), new OpenSubtitlesFileHashCalculator());
    }

    OpenSubtitlesClientImpl(XmlRpcClient xmlRpcClient, ResponseParser responseParser, FileHashCalculator fileHashCalculator) {
        this.xmlRpcClient = xmlRpcClient;
        this.responseParser = responseParser;
        this.fileHashCalculator = fileHashCalculator;
    }

    @Override
    public ServerInfo serverInfo() throws XmlRpcException {
        ServerInfoOperation operation = new ServerInfoOperation();
        return (ServerInfo)operation.execute(this.xmlRpcClient, this.responseParser);
    }

    @Override
    public Response login(String lang, String useragent) throws XmlRpcException {
        return this.login("", "", lang, useragent);
    }

    @Override
    public Response login(String user, String pass, String lang, String useragent) throws XmlRpcException {
        this.ensureNotLoggedIn();
        LoginToken loginToken = (LoginToken)new LogInOperation(user, pass, lang, useragent).execute(this.xmlRpcClient, this.responseParser);
        if (ResponseStatus.OK.equals(loginToken.getStatus())) {
            this.loginToken = loginToken;
        }
        return loginToken;
    }

    private void ensureNotLoggedIn() {
        if (this.loginToken != null) {
            throw new IllegalStateException("Already logged in! Please log out first.");
        }
    }

    @Override
    public void logout() throws XmlRpcException {
        this.ensureLoggedIn();
        new LogOutOperation(this.loginToken.getToken()).execute(this.xmlRpcClient, this.responseParser);
        this.loginToken = null;
    }

    private void ensureLoggedIn() {
        if (this.loginToken == null) {
            throw new IllegalStateException("Not logged in!");
        }
    }

    @Override
    public boolean isLoggedIn() {
        return this.loginToken != null;
    }

    @Override
    public void noop() throws XmlRpcException {
        this.ensureLoggedIn();
        new NoopOperation(this.loginToken.getToken()).execute(this.xmlRpcClient, this.responseParser);
    }

    @Override
    public List<SubtitleInfo> searchSubtitles(String lang, File file) throws IOException, XmlRpcException {
        this.ensureLoggedIn();
        String hash = this.fileHashCalculator.calculateHash(file);
        long size = file.length();
        return this.searchSubtitles(lang, hash, String.valueOf(size));
    }

    @Override
    public List<SubtitleInfo> searchSubtitles(String lang, String hash, String movieByteSize) throws XmlRpcException {
        return this.searchSubtitles(lang, hash, movieByteSize, null, null, null, null, null);
    }

    @Override
    public List<SubtitleInfo> searchSubtitles(String lang, String imdbId) throws XmlRpcException {
        return this.searchSubtitles(lang, null, null, imdbId, null, null, null, null);
    }

    @Override
    public List<SubtitleInfo> searchSubtitles(String lang, String query, String season, String episode) throws XmlRpcException {
        return this.searchSubtitles(lang, null, null, null, query, season, episode, null);
    }

    @Override
    public List<SubtitleInfo> searchSubtitles(String lang, String movieHash, String movieByteSize, String imdbid, String query, String season, String episode, String tag) throws XmlRpcException {
        this.ensureLoggedIn();
        return new SearchOperation(this.loginToken.getToken(), lang, movieHash, movieByteSize, tag, imdbid, query, season, episode).execute(this.xmlRpcClient, this.responseParser);
    }

    @Override
    public List<SubtitleFile> downloadSubtitles(int subtitleFileID) throws XmlRpcException {
        this.ensureLoggedIn();
        return new DownloadSubtitlesOperation(this.loginToken.getToken(), subtitleFileID).execute(this.xmlRpcClient, this.responseParser);
    }

    @Override
    public List<MovieInfo> searchMoviesOnImdb(String query) throws XmlRpcException {
        this.ensureLoggedIn();
        return new ImdbSearchOperation(this.loginToken.getToken(), query).execute(this.xmlRpcClient, this.responseParser);
    }
}

