/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api;

import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;

/**
 * IntIterable is an interface which is memory-optimized for int primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an IntIterator. IntIterator helps iterate over the IntIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface IntIterable extends PrimitiveIterable
{
    IntIterator intIterator();

    int[] toArray();

    boolean contains(int value);

    boolean containsAll(int... source);

    boolean containsAll(IntIterable source);

    void forEach(IntProcedure procedure);

    IntIterable select(IntPredicate predicate);

    IntIterable reject(IntPredicate predicate);

    <V> RichIterable<V> collect(IntToObjectFunction<? extends V> function);

    int detectIfNone(IntPredicate predicate, int ifNone);

    int count(IntPredicate predicate);

    boolean anySatisfy(IntPredicate predicate);

    boolean allSatisfy(IntPredicate predicate);

    boolean noneSatisfy(IntPredicate predicate);

    MutableIntList toList();

    MutableIntSet toSet();

    MutableIntBag toBag();

    LazyIntIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function);

    long sum();

    int max();

    int maxIfEmpty(int defaultValue);

    int min();

    int minIfEmpty(int defaultValue);

    double average();

    double median();

    int[] toSortedArray();

    MutableIntList toSortedList();

}
