/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.collection.primitive;

import java.util.Collection;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;

/**
 * This file was automatically generated from template file mutablePrimitiveCollection.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatCollection extends FloatIterable
{
    boolean add(float element);

    boolean addAll(float... source);

    boolean addAll(FloatIterable source);

    boolean remove(float value);

    boolean removeAll(FloatIterable source);

    boolean removeAll(float... source);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(FloatIterable elements);

    /**
     * @see Collection#retainAll(Collection)
     * @since 5.0
     */
    boolean retainAll(float... source);

    void clear();

    MutableFloatCollection select(FloatPredicate predicate);

    MutableFloatCollection reject(FloatPredicate predicate);

    <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function);

    MutableFloatCollection with(float element);

    MutableFloatCollection without(float element);

    MutableFloatCollection withAll(FloatIterable elements);

    MutableFloatCollection withoutAll(FloatIterable elements);

    MutableFloatCollection asUnmodifiable();

    MutableFloatCollection asSynchronized();

    ImmutableFloatCollection toImmutable();
}
