/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.set.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.set.primitive.ImmutableCharSet;

/**
 * A factory which creates instances of type {@link ImmutableCharSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableCharSetFactory
{
    /**
     * Same as {@link #with()}.
     */
    ImmutableCharSet of();

    ImmutableCharSet with();

    /**
     * Same as {@link #with(char)}.
     */
    ImmutableCharSet of(char one);

    ImmutableCharSet with(char one);

    /**
     * Same as {@link #with(char[])}.
     */
    ImmutableCharSet of(char... items);

    ImmutableCharSet with(char... items);

    /**
     * Same as {@link #withAll(CharIterable)}.
     */
    ImmutableCharSet ofAll(CharIterable items);

    ImmutableCharSet withAll(CharIterable items);
}
