/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.predicate.primitive.ByteLongPredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableByteLongMap extends ByteLongMap
{
    ImmutableByteLongMap select(ByteLongPredicate predicate);

    ImmutableByteLongMap reject(ByteLongPredicate predicate);

    ImmutableLongCollection select(LongPredicate predicate);

    ImmutableLongCollection reject(LongPredicate predicate);

    <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    ImmutableByteLongMap newWithKeyValue(byte key, long value);

    ImmutableByteLongMap newWithoutKey(byte key);

    ImmutableByteLongMap newWithoutAllKeys(ByteIterable keys);
}
