/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;

/**
 * This file was automatically generated from template file immutableObjectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableObjectDoubleMap<K> extends ObjectDoubleMap<K>
{
    ImmutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> predicate);

    ImmutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> predicate);

    ImmutableDoubleCollection select(DoublePredicate predicate);

    ImmutableDoubleCollection reject(DoublePredicate predicate);

    <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableObjectDoubleMap<K> newWithKeyValue(K key, double value);

    ImmutableObjectDoubleMap<K> newWithoutKey(K key);

    ImmutableObjectDoubleMap<K> newWithoutAllKeys(Iterable<? extends K> keys);
}
