/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.function.primitive.ByteToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ByteShortPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableByteShortMap extends ByteShortMap
{
    void clear();

    void put(byte key, short value);

    void putAll(ByteShortMap map);

    void removeKey(byte key);

    void remove(byte key);

    short removeKeyIfAbsent(byte key, short value);

    short getIfAbsentPut(byte key, short value);

    short getIfAbsentPut(byte key, ShortFunction0 function);

    short getIfAbsentPutWithKey(byte key, ByteToShortFunction function);

    <P> short getIfAbsentPutWith(byte key, ShortFunction<? super P> function, P parameter);

    short updateValue(byte key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableByteShortMap select(ByteShortPredicate predicate);

    MutableByteShortMap reject(ByteShortPredicate predicate);

    MutableShortCollection select(ShortPredicate predicate);

    MutableShortCollection reject(ShortPredicate predicate);

    <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function);

    MutableByteShortMap withKeyValue(byte key, short value);

    MutableByteShortMap withoutKey(byte key);

    MutableByteShortMap withoutAllKeys(ByteIterable keys);

    MutableByteShortMap asUnmodifiable();

    MutableByteShortMap asSynchronized();

    short addToValue(byte key, short toBeAdded);
}
