/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.function.primitive.FloatToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.FloatLongPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableFloatLongMap extends FloatLongMap
{
    void clear();

    void put(float key, long value);

    void putAll(FloatLongMap map);

    void removeKey(float key);

    void remove(float key);

    long removeKeyIfAbsent(float key, long value);

    long getIfAbsentPut(float key, long value);

    long getIfAbsentPut(float key, LongFunction0 function);

    long getIfAbsentPutWithKey(float key, FloatToLongFunction function);

    <P> long getIfAbsentPutWith(float key, LongFunction<? super P> function, P parameter);

    long updateValue(float key, long initialValueIfAbsent, LongToLongFunction function);

    MutableFloatLongMap select(FloatLongPredicate predicate);

    MutableFloatLongMap reject(FloatLongPredicate predicate);

    MutableLongCollection select(LongPredicate predicate);

    MutableLongCollection reject(LongPredicate predicate);

    <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    MutableFloatLongMap withKeyValue(float key, long value);

    MutableFloatLongMap withoutKey(float key);

    MutableFloatLongMap withoutAllKeys(FloatIterable keys);

    MutableFloatLongMap asUnmodifiable();

    MutableFloatLongMap asSynchronized();

    long addToValue(float key, long toBeAdded);
}
