/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import java.util.Set;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.tuple.primitive.ObjectBytePair;

/**
 * This file was automatically generated from template file objectPrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ObjectByteMap<K> extends ByteIterable
{
    byte get(Object key);

    byte getOrThrow(Object key);

    byte getIfAbsent(Object key, byte ifAbsent);

    boolean containsKey(Object key);

    boolean containsValue(byte value);

    void forEachValue(ByteProcedure procedure);

    void forEachKey(Procedure<? super K> procedure);

    void forEachKeyValue(ObjectByteProcedure<? super K> procedure);

    ObjectByteMap<K> select(ObjectBytePredicate<? super K> predicate);

    ObjectByteMap<K> reject(ObjectBytePredicate<? super K> predicate);

    /**
     * Returns a string representation of this ObjectByteMap. The string representation consists of a list of the
     * map's key-value pairs in the order they are returned by its iterator. The key and value in each key-value pair are separated
     * by a colon (<tt>":"</tt>) and each pair is enclosed in square brackets (<tt>"[]"</tt>). Adjacent key-value pairs
     * are separated by the characters <tt>", "</tt> (comma and space). Keys and values are converted to strings as by
     * String#valueOf().
     *
     * @return a string representation of this ObjectByteMap
     */
    String toString();

    ImmutableObjectByteMap<K> toImmutable();

    Set<K> keySet();

    MutableByteCollection values();

    /**
     * @since 5.0
     */
    LazyIterable<K> keysView();

    /**
     * @since 5.0
     */
    RichIterable<ObjectBytePair<K>> keyValuesView();
}
