/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.primitive.DoubleBags;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveBag.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableDoubleBag
        extends AbstractUnmodifiableDoubleCollection
        implements MutableDoubleBag
{
    private static final long serialVersionUID = 1L;

    UnmodifiableDoubleBag(MutableDoubleBag bag)
    {
        super(bag);
    }

    private MutableDoubleBag getMutableDoubleBag()
    {
        return (MutableDoubleBag) this.getDoubleCollection();
    }

    @Override
    public UnmodifiableDoubleBag with(double element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleBag without(double element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleBag withAll(DoubleIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableDoubleBag withoutAll(DoubleIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public void addOccurrences(double item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(double item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct()
    {
        return this.getMutableDoubleBag().sizeDistinct();
    }

    public int occurrencesOf(double item)
    {
        return this.getMutableDoubleBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(DoubleIntProcedure procedure)
    {
        this.getMutableDoubleBag().forEachWithOccurrences(procedure);
    }

    @Override
    public MutableDoubleBag select(DoublePredicate predicate)
    {
        return this.getMutableDoubleBag().select(predicate);
    }

    @Override
    public MutableDoubleBag reject(DoublePredicate predicate)
    {
        return this.getMutableDoubleBag().reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.getMutableDoubleBag().collect(function);
    }

    @Override
    public boolean equals(Object otherBag)
    {
        return this.getMutableDoubleBag().equals(otherBag);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableDoubleBag().hashCode();
    }

    @Override
    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public MutableDoubleBag asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableDoubleBag asSynchronized()
    {
        return new SynchronizedDoubleBag(this);
    }

    @Override
    public ImmutableDoubleBag toImmutable()
    {
        return DoubleBags.immutable.withAll(this);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableDoubleBag().injectInto(injectedValue, function);
    }
}
