/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import java.io.IOException;
import java.util.NoSuchElementException;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.lazy.ReverseIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;

/**
 * This file was automatically generated from template file reversePrimitiveIterable.stg.
 *
 * @see ReverseIterable
 * @since 5.0.
 */
public class ReverseFloatIterable extends AbstractLazyFloatIterable
{
    private final FloatList adapted;

    public ReverseFloatIterable(FloatList newAdapted)
    {
        this.adapted = newAdapted;
    }

    public static ReverseFloatIterable adapt(FloatList floatList)
    {
        return new ReverseFloatIterable(floatList);
    }

    public FloatIterator floatIterator()
    {
        return new ReverseFloatIterator();
    }

    public void forEach(FloatProcedure procedure)
    {
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext())
        {
            procedure.value(iterator.next());
        }
    }

    public double sum()
    {
        return this.adapted.sum();
    }

    public float max()
    {
        return this.adapted.max();
    }

    public float min()
    {
        return this.adapted.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        if (this.adapted.isEmpty())
        {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public float maxIfEmpty(float defaultValue)
    {
        if (this.adapted.isEmpty())
        {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average()
    {
        return this.adapted.average();
    }

    public double median()
    {
        return this.adapted.median();
    }

    public float[] toSortedArray()
    {
        return this.adapted.toSortedArray();
    }

    public MutableFloatList toSortedList()
    {
        return FloatArrayList.newList(this).sortThis();
    }


    @Override
    public float[] toArray()
    {
        float[] results = new float[this.adapted.size()];
        int index = 0;
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext())
        {
            results[index] = iterator.next();
            index++;
        }
        return results;
    }

    @Override
    public boolean contains(float value)
    {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(float... source)
    {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(FloatIterable source)
    {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size()
    {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty()
    {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty()
    {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableFloatList toList()
    {
        return FloatArrayList.newList(this);
    }

    @Override
    public MutableFloatSet toSet()
    {
        return FloatHashSet.newSet(this);
    }

    @Override
    public MutableFloatBag toBag()
    {
        return FloatHashBag.newBag(this);
    }

    @Override
    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    private class ReverseFloatIterator implements FloatIterator
    {
        /**
         * Index of element to be returned by subsequent call to next.
         */
        private int currentIndex = ReverseFloatIterable.this.adapted.size() - 1;

        public boolean hasNext()
        {
            return this.currentIndex != -1;
        }

        public float next()
        {
            if (!this.hasNext())
            {
                throw new NoSuchElementException();
            }
            float next = ReverseFloatIterable.this.adapted.get(this.currentIndex);
            this.currentIndex--;
            return next;
        }
    }
}