/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteBooleanMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteBooleanMap;
import com.gs.collections.api.map.primitive.ByteBooleanMap;

/**
 * ImmutableByteBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteBooleanMapFactoryImpl implements ImmutableByteBooleanMapFactory
{
    public ImmutableByteBooleanMap of()
    {
        return this.with();
    }

    public ImmutableByteBooleanMap with()
    {
        return ImmutableByteBooleanEmptyMap.INSTANCE;
    }

    public ImmutableByteBooleanMap of(byte key, boolean value)
    {
        return this.with(key, value);
    }

    public ImmutableByteBooleanMap with(byte key, boolean value)
    {
        return new ImmutableByteBooleanSingletonMap(key, value);
    }

    public ImmutableByteBooleanMap ofAll(ByteBooleanMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteBooleanMap withAll(ByteBooleanMap map)
    {
        if (map instanceof ImmutableByteBooleanMap)
        {
            return (ImmutableByteBooleanMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteBooleanSingletonMap(key, map.get(key));
        }
        return new ImmutableByteBooleanHashMap(map);
    }
}
