/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteByteMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteByteMap;
import com.gs.collections.api.map.primitive.ByteByteMap;

/**
 * ImmutableByteByteMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteByteMapFactoryImpl implements ImmutableByteByteMapFactory
{
    public ImmutableByteByteMap of()
    {
        return this.with();
    }

    public ImmutableByteByteMap with()
    {
        return ImmutableByteByteEmptyMap.INSTANCE;
    }

    public ImmutableByteByteMap of(byte key, byte value)
    {
        return this.with(key, value);
    }

    public ImmutableByteByteMap with(byte key, byte value)
    {
        return new ImmutableByteByteSingletonMap(key, value);
    }

    public ImmutableByteByteMap ofAll(ByteByteMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteByteMap withAll(ByteByteMap map)
    {
        if (map instanceof ImmutableByteByteMap)
        {
            return (ImmutableByteByteMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteByteSingletonMap(key, map.get(key));
        }
        return new ImmutableByteByteHashMap(map);
    }
}
