/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableByteLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableByteLongMap;
import com.gs.collections.api.map.primitive.ByteLongMap;

/**
 * ImmutableByteLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteLongMapFactoryImpl implements ImmutableByteLongMapFactory
{
    public ImmutableByteLongMap of()
    {
        return this.with();
    }

    public ImmutableByteLongMap with()
    {
        return ImmutableByteLongEmptyMap.INSTANCE;
    }

    public ImmutableByteLongMap of(byte key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableByteLongMap with(byte key, long value)
    {
        return new ImmutableByteLongSingletonMap(key, value);
    }

    public ImmutableByteLongMap ofAll(ByteLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableByteLongMap withAll(ByteLongMap map)
    {
        if (map instanceof ImmutableByteLongMap)
        {
            return (ImmutableByteLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            byte key = map.keysView().byteIterator().next();
            return new ImmutableByteLongSingletonMap(key, map.get(key));
        }
        return new ImmutableByteLongHashMap(map);
    }
}
