/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.CharShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.CharShortProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.CharShortMap;
import com.gs.collections.api.map.primitive.ImmutableCharShortMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.CharShortPair;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyCharIterate;

/**
 * ImmutableCharShortEmptyMap is an optimization for {@link ImmutableCharShortMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableCharShortEmptyMap implements ImmutableCharShortMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_VALUE = (short) 0;
    static final ImmutableCharShortMap INSTANCE = new ImmutableCharShortEmptyMap();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public short get(char key)
    {
        return EMPTY_VALUE;
    }

    public short getIfAbsent(char key, short ifAbsent)
    {
        return ifAbsent;
    }

    public short getOrThrow(char key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key)
    {
        return false;
    }

    public boolean containsValue(short value)
    {
        return false;
    }

    public void forEachValue(ShortProcedure procedure)
    {
    }

    public void forEachKey(CharProcedure procedure)
    {
    }

    public void forEachKeyValue(CharShortProcedure procedure)
    {
    }

    public LazyCharIterable keysView()
    {
        return LazyCharIterate.empty();
    }

    public RichIterable<CharShortPair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableCharShortMap select(CharShortPredicate predicate)
    {
        return this;
    }

    public ImmutableCharShortMap reject(CharShortPredicate predicate)
    {
        return this;
    }

    public ImmutableCharShortMap toImmutable()
    {
        return this;
    }

    public ShortIterator shortIterator()
    {
        return new InternalShortIterator();
    }

    private static class InternalShortIterator implements ShortIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public short next()
        {
            throw new NoSuchElementException();
        }
    }

    public void forEach(ShortProcedure procedure)
    {
    }

    public int count(ShortPredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public short min()
    {
        throw new NoSuchElementException();
    }

    public short max()
    {
        throw new NoSuchElementException();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public short minIfEmpty(short defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public short[] toSortedArray()
    {
        return new short[0];
    }

    public MutableShortList toSortedList()
    {
        return new ShortArrayList();
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return true;
    }

    public ImmutableShortCollection select(ShortPredicate predicate)
    {
        return ShortLists.immutable.with();
    }

    public ImmutableShortCollection reject(ShortPredicate predicate)
    {
        return ShortLists.immutable.with();
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public short[] toArray()
    {
        return new short[0];
    }

    public boolean contains(short value)
    {
        return false;
    }

    public boolean containsAll(short... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ShortIterable source)
    {
        return source.isEmpty();
    }

    public MutableShortList toList()
    {
        return new ShortArrayList();
    }

    public MutableShortSet toSet()
    {
        return new ShortHashSet();
    }

    public MutableShortBag toBag()
    {
        return new ShortHashBag();
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public ImmutableCharShortMap newWithKeyValue(char key, short value)
    {
        return new ImmutableCharShortSingletonMap(key, value);
    }

    public ImmutableCharShortMap newWithoutKey(char key)
    {
        return this;
    }

    public ImmutableCharShortMap newWithoutAllKeys(CharIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableCharSet keySet()
    {
        return UnmodifiableCharSet.of(new CharHashSet());
    }

    public MutableShortCollection values()
    {
        return UnmodifiableShortCollection.of(new ShortArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof CharShortMap))
        {
            return false;
        }
        CharShortMap map = (CharShortMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
