/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableCharShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableCharShortMap;
import com.gs.collections.api.map.primitive.CharShortMap;

/**
 * ImmutableCharShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharShortMapFactoryImpl implements ImmutableCharShortMapFactory
{
    public ImmutableCharShortMap of()
    {
        return this.with();
    }

    public ImmutableCharShortMap with()
    {
        return ImmutableCharShortEmptyMap.INSTANCE;
    }

    public ImmutableCharShortMap of(char key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableCharShortMap with(char key, short value)
    {
        return new ImmutableCharShortSingletonMap(key, value);
    }

    public ImmutableCharShortMap ofAll(CharShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableCharShortMap withAll(CharShortMap map)
    {
        if (map instanceof ImmutableCharShortMap)
        {
            return (ImmutableCharShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharShortSingletonMap(key, map.get(key));
        }
        return new ImmutableCharShortHashMap(map);
    }
}
