/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatShortMap;
import com.gs.collections.api.map.primitive.FloatShortMap;

/**
 * ImmutableFloatShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatShortMapFactoryImpl implements ImmutableFloatShortMapFactory
{
    public ImmutableFloatShortMap of()
    {
        return this.with();
    }

    public ImmutableFloatShortMap with()
    {
        return ImmutableFloatShortEmptyMap.INSTANCE;
    }

    public ImmutableFloatShortMap of(float key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatShortMap with(float key, short value)
    {
        return new ImmutableFloatShortSingletonMap(key, value);
    }

    public ImmutableFloatShortMap ofAll(FloatShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatShortMap withAll(FloatShortMap map)
    {
        if (map instanceof ImmutableFloatShortMap)
        {
            return (ImmutableFloatShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatShortSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatShortHashMap(map);
    }
}
