/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Set;

import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ObjectBytePredicate;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.ObjectByteProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.ImmutableObjectByteMap;
import com.gs.collections.api.map.primitive.ObjectByteMap;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.tuple.primitive.ObjectBytePair;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.utility.LazyIterate;

/**
 * ImmutableObjectByteEmptyMap is an optimization for {@link ImmutableObjectByteMap} of size 0.
 * This file was automatically generated from template file immutableObjectPrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectByteEmptyMap<K> implements ImmutableObjectByteMap<K>, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = (byte) 0;
    static final ImmutableObjectByteMap<?> INSTANCE = new ImmutableObjectByteEmptyMap<Object>();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public ByteIterator byteIterator()
    {
        return new InternalByteIterator();
    }

    private static class InternalByteIterator implements ByteIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public byte next()
        {
            throw new NoSuchElementException();
        }
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public ImmutableByteCollection select(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public ImmutableByteCollection reject(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public long sum()
    {
        return 0L;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(byte... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public ImmutableObjectByteMap<K> newWithKeyValue(K key, byte value)
    {
        return new ImmutableObjectByteSingletonMap<K>(key, value);
    }

    public ImmutableObjectByteMap<K> newWithoutKey(K key)
    {
        return this;
    }

    public ImmutableObjectByteMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        return this;
    }

    public byte get(Object key)
    {
        return EMPTY_VALUE;
    }

    public byte getOrThrow(Object key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public byte getIfAbsent(Object key, byte ifAbsent)
    {
        return ifAbsent;
    }

    public boolean containsKey(Object key)
    {
        return false;
    }

    public boolean containsValue(byte value)
    {
        return false;
    }

    public void forEachValue(ByteProcedure procedure)
    {
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
    }

    public void forEachKeyValue(ObjectByteProcedure<? super K> objectByteProcedure)
    {
    }

    public ImmutableObjectByteMap<K> select(ObjectBytePredicate<? super K> objectBytePredicate)
    {
        return this;
    }

    public ImmutableObjectByteMap<K> reject(ObjectBytePredicate<? super K> objectBytePredicate)
    {
        return this;
    }

    public ImmutableObjectByteMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public Set<K> keySet()
    {
        return Sets.immutable.<K>of().castToSet();
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(new ByteArrayList());
    }

    public LazyIterable<K> keysView()
    {
        return LazyIterate.empty();
    }

    public RichIterable<ObjectBytePair<K>> keyValuesView()
    {
        return LazyIterate.empty();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ObjectByteMap))
        {
            return false;
        }
        ObjectByteMap<K> map = (ObjectByteMap<K>) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
