/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableByteSetFactory;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;

/**
 * ImmutableByteSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteSetFactoryImpl implements ImmutableByteSetFactory
{
    public ImmutableByteSet of()
    {
        return this.with();
    }

    public ImmutableByteSet with()
    {
        return ImmutableByteEmptySet.INSTANCE;
    }

    public ImmutableByteSet of(byte one)
    {
        return this.with(one);
    }

    public ImmutableByteSet with(byte one)
    {
        return new ImmutableByteSingletonSet(one);
    }

    public ImmutableByteSet of(byte... items)
    {
        return this.with(items);
    }

    public ImmutableByteSet with(byte... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ByteHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableByteSet ofAll(ByteIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableByteSet withAll(ByteIterable items)
    {
        if (items instanceof ImmutableByteSet)
        {
            return (ImmutableByteSet) items;
        }
        return this.with(items.toArray());
    }
}
