/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableFloatSetFactory;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;

/**
 * ImmutableFloatSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatSetFactoryImpl implements ImmutableFloatSetFactory
{
    public ImmutableFloatSet of()
    {
        return this.with();
    }

    public ImmutableFloatSet with()
    {
        return ImmutableFloatEmptySet.INSTANCE;
    }

    public ImmutableFloatSet of(float one)
    {
        return this.with(one);
    }

    public ImmutableFloatSet with(float one)
    {
        return new ImmutableFloatSingletonSet(one);
    }

    public ImmutableFloatSet of(float... items)
    {
        return this.with(items);
    }

    public ImmutableFloatSet with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return FloatHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableFloatSet ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableFloatSet withAll(FloatIterable items)
    {
        if (items instanceof ImmutableFloatSet)
        {
            return (ImmutableFloatSet) items;
        }
        return this.with(items.toArray());
    }
}
