/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableShortSetFactory;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;

/**
 * ImmutableShortSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortSetFactoryImpl implements ImmutableShortSetFactory
{
    public ImmutableShortSet of()
    {
        return this.with();
    }

    public ImmutableShortSet with()
    {
        return ImmutableShortEmptySet.INSTANCE;
    }

    public ImmutableShortSet of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortSet with(short one)
    {
        return new ImmutableShortSingletonSet(one);
    }

    public ImmutableShortSet of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortSet with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ShortHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableShortSet ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortSet withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortSet)
        {
            return (ImmutableShortSet) items;
        }
        return this.with(items.toArray());
    }
}
