/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.FloatList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableFloatStack;
import com.gs.collections.api.stack.primitive.MutableFloatStack;
import com.gs.collections.impl.factory.primitive.FloatStacks;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveStack.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableFloatStack
        implements MutableFloatStack, Serializable
{
    private static final long serialVersionUID = 1L;

    private final MutableFloatStack stack;

    UnmodifiableFloatStack(MutableFloatStack stack)
    {
        this.stack = stack;
    }

    public void push(float item)
    {
        throw new UnsupportedOperationException("Cannot call push() on " + this.getClass().getSimpleName());
    }

    public float pop()
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public FloatList pop(int count)
    {
        throw new UnsupportedOperationException("Cannot call pop() on " + this.getClass().getSimpleName());
    }

    public float peek()
    {
        return this.stack.peek();
    }

    public FloatList peek(int count)
    {
        return this.stack.peek(count);
    }

    public float peekAt(int index)
    {
        return this.stack.peekAt(index);
    }

    public int size()
    {
        return this.stack.size();
    }

    public boolean isEmpty()
    {
        return this.stack.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.stack.notEmpty();
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(float value)
    {
        return this.stack.contains(value);
    }

    public boolean containsAll(float... source)
    {
        return this.stack.containsAll(source);
    }

    public boolean containsAll(FloatIterable source)
    {
        return this.stack.containsAll(source);
    }

    public FloatIterator floatIterator()
    {
        return this.stack.floatIterator();
    }

    public void forEach(FloatProcedure procedure)
    {
        this.stack.forEach(procedure);
    }

    public int count(FloatPredicate predicate)
    {
        return this.stack.count(predicate);
    }

    public boolean anySatisfy(FloatPredicate predicate)
    {
        return this.stack.anySatisfy(predicate);
    }

    public boolean allSatisfy(FloatPredicate predicate)
    {
        return this.stack.allSatisfy(predicate);
    }

    public boolean noneSatisfy(FloatPredicate predicate)
    {
        return this.stack.noneSatisfy(predicate);
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone)
    {
        return this.stack.detectIfNone(predicate, ifNone);
    }

    public MutableFloatStack select(FloatPredicate predicate)
    {
        return this.stack.select(predicate);
    }

    public MutableFloatStack reject(FloatPredicate predicate)
    {
        return this.stack.reject(predicate);
    }

    public <V> MutableStack<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.stack.collect(function);
    }

    public double sum()
    {
        return this.stack.sum();
    }

    public float max()
    {
        return this.stack.max();
    }

    public float min()
    {
        return this.stack.min();
    }

    public float minIfEmpty(float defaultValue)
    {
        return this.stack.minIfEmpty(defaultValue);
    }

    public float maxIfEmpty(float defaultValue)
    {
        return this.stack.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.stack.average();
    }

    public double median()
    {
        return this.stack.median();
    }

    public MutableFloatList toSortedList()
    {
        return this.stack.toSortedList();
    }

    public float[] toSortedArray()
    {
        return this.stack.toSortedArray();
    }

    public float[] toArray()
    {
        return this.stack.toArray();
    }

    @Override
    public String toString()
    {
        return this.stack.toString();
    }

    public String makeString()
    {
        return this.stack.makeString();
    }

    public String makeString(String separator)
    {
        return this.stack.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.stack.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.stack.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.stack.appendString(appendable, separator);
    }

    public void appendString(
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        this.stack.appendString(appendable, start, separator, end);
    }

    public MutableFloatList toList()
    {
        return this.stack.toList();
    }

    public MutableFloatSet toSet()
    {
        return this.stack.toSet();
    }

    public MutableFloatBag toBag()
    {
        return this.stack.toBag();
    }

    @Override
    public boolean equals(Object otherStack)
    {
        return this.stack.equals(otherStack);
    }

    @Override
    public int hashCode()
    {
        return this.stack.hashCode();
    }

    public LazyFloatIterable asLazy()
    {
        return new LazyFloatIterableAdapter(this);
    }

    public MutableFloatStack asUnmodifiable()
    {
        return this;
    }

    public MutableFloatStack asSynchronized()
    {
        return new SynchronizedFloatStack(this);
    }

    public ImmutableFloatStack toImmutable()
    {
        return FloatStacks.immutable.withAllReversed(this);
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function)
    {
        return this.stack.injectInto(injectedValue, function);
    }
}