/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.tuple.primitive;

import com.gs.collections.api.tuple.primitive.ObjectCharPair;
import com.gs.collections.impl.block.factory.Comparators;

/**
 * This file was automatically generated from template file objectPrimitivePairImpl.stg
 */
public class ObjectCharPairImpl<T> implements ObjectCharPair<T>
{
    private static final long serialVersionUID = 1L;

    private final T one;
    private final char two;

    ObjectCharPairImpl(T newOne, char newTwo)
    {
        this.one = newOne;
        this.two = newTwo;
    }

    public T getOne()
    {
        return this.one;
    }

    public char getTwo()
    {
        return this.two;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if (!(o instanceof ObjectCharPair))
        {
            return false;
        }

        ObjectCharPair<?> that = (ObjectCharPair<?>) o;

        return Comparators.nullSafeEquals(this.one, that.getOne())
                && this.two == that.getTwo();
    }

    @Override
    public int hashCode()
    {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + (int) this.two;
        return result;
    }

    @Override
    public String toString()
    {
        return this.one + ":" + this.two;
    }

    public int compareTo(ObjectCharPair<T> that)
    {
        int i = ((Comparable<T>) this.one).compareTo(that.getOne());
        if (i != 0)
        {
            return i;
        }
        return this.two - that.getTwo();
    }
}
