/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.parallel.list;

import com.gs.collections.api.annotation.Beta;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.impl.block.factory.Functions;
import com.gs.collections.impl.lazy.parallel.AbstractBatch;
import com.gs.collections.impl.lazy.parallel.list.DistinctBatch;
import com.gs.collections.impl.lazy.parallel.list.ListBatch;
import com.gs.collections.impl.lazy.parallel.list.SelectListBatch;
import com.gs.collections.impl.lazy.parallel.set.UnsortedSetBatch;
import com.gs.collections.impl.map.mutable.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class CollectListBatch<T, V>
extends AbstractBatch<V>
implements ListBatch<V> {
    private final ListBatch<T> listBatch;
    private final Function<? super T, ? extends V> function;

    public CollectListBatch(ListBatch<T> listBatch, Function<? super T, ? extends V> function) {
        this.listBatch = listBatch;
        this.function = function;
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.listBatch.forEach(Functions.bind(procedure, this.function));
    }

    @Override
    public ListBatch<V> select(Predicate<? super V> predicate) {
        return new SelectListBatch<V>(this, predicate);
    }

    @Override
    public <VV> ListBatch<VV> collect(Function<? super V, ? extends VV> function) {
        return new CollectListBatch<V, VV>(this, function);
    }

    @Override
    public UnsortedSetBatch<V> distinct(ConcurrentHashMap<V, Boolean> distinct) {
        return new DistinctBatch<V>(this, distinct);
    }
}

