/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatIntPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.FloatIntProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.FloatIntMap;
import com.gs.collections.api.map.primitive.ImmutableFloatIntMap;
import com.gs.collections.api.map.primitive.MutableFloatIntMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.FloatIntPair;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.map.mutable.primitive.FloatIntHashMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableFloatIntHashMap
implements ImmutableFloatIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatIntMap delegate;

    ImmutableFloatIntHashMap(FloatIntMap delegate) {
        this.delegate = new FloatIntHashMap(delegate);
    }

    public int get(float key) {
        return this.delegate.get(key);
    }

    public int getIfAbsent(float key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(float key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatIntProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<FloatIntPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableFloatIntMap select(FloatIntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatIntMap reject(FloatIntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return ((FloatIntHashMap)this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableFloatIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return this.delegate.intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    public int[] toArray() {
        return this.delegate.toArray();
    }

    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableIntList toList() {
        return this.delegate.toList();
    }

    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableFloatIntMap newWithKeyValue(float key, int value) {
        FloatIntHashMap map = new FloatIntHashMap(this.size() + 1);
        map.putAll((FloatIntMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatIntMap newWithoutKey(float key) {
        FloatIntHashMap map = new FloatIntHashMap(this.size());
        map.putAll((FloatIntMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatIntMap newWithoutAllKeys(FloatIterable keys) {
        FloatIntHashMap map = new FloatIntHashMap(this.size());
        map.putAll((FloatIntMap)this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.delegate.keySet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableFloatIntMapSerializationProxy((FloatIntMap)this);
    }

    protected static class ImmutableFloatIntMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FloatIntMap map;

        public ImmutableFloatIntMapSerializationProxy() {
        }

        protected ImmutableFloatIntMapSerializationProxy(FloatIntMap map) {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((FloatIntProcedure)new CheckedFloatIntProcedure(){

                    public void safeValue(float key, int value) throws IOException {
                        out.writeFloat(key);
                        out.writeInt(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            FloatIntHashMap deserializedMap = new FloatIntHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readFloat(), in.readInt());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

