/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToBooleanFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.LongBooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.LongBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableLongBooleanMap;
import com.gs.collections.api.map.primitive.LongBooleanMap;
import com.gs.collections.api.map.primitive.MutableLongBooleanMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.BooleanSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongBooleanPair;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.bag.mutable.primitive.LongHashBag;
import com.gs.collections.impl.block.factory.primitive.LongPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedBooleanCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.LongBooleanMaps;
import com.gs.collections.impl.factory.primitive.LongSets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.CollectLongToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectLongIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedLongBooleanMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableLongBooleanMap;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedLongSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongBooleanHashMap
implements MutableLongBooleanMap,
Externalizable {
    static final boolean EMPTY_VALUE = false;
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    @Deprecated
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private long[] keys;
    private BitSet values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public LongBooleanHashMap() {
        this.allocateTable(16);
    }

    public LongBooleanHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public LongBooleanHashMap(LongBooleanMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    @Deprecated
    public LongBooleanHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity);
    }

    public MutableLongBooleanMap asUnmodifiable() {
        return new UnmodifiableLongBooleanMap(this);
    }

    public MutableLongBooleanMap asSynchronized() {
        return new SynchronizedLongBooleanMap(this);
    }

    public ImmutableLongBooleanMap toImmutable() {
        return LongBooleanMaps.immutable.withAll((LongBooleanMap)this);
    }

    public static LongBooleanHashMap newWithKeysValues(long key1, boolean value1) {
        return new LongBooleanHashMap(1).withKeyValue(key1, value1);
    }

    public static LongBooleanHashMap newWithKeysValues(long key1, boolean value1, long key2, boolean value2) {
        return new LongBooleanHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static LongBooleanHashMap newWithKeysValues(long key1, boolean value1, long key2, boolean value2, long key3, boolean value3) {
        return new LongBooleanHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static LongBooleanHashMap newWithKeysValues(long key1, boolean value1, long key2, boolean value2, long key3, boolean value3, long key4, boolean value4) {
        return new LongBooleanHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public LongBooleanHashMap withKeyValue(long key1, boolean value1) {
        this.put(key1, value1);
        return this;
    }

    public LongBooleanHashMap withKeysValues(long key1, boolean value1, long key2, boolean value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongBooleanHashMap withKeysValues(long key1, boolean value1, long key2, boolean value2, long key3, boolean value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongBooleanHashMap withKeysValues(long key1, boolean value1, long key2, boolean value2, long key3, boolean value3, long key4, boolean value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public LongBooleanHashMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public LongBooleanHashMap withoutAllKeys(LongIterable keys) {
        keys.forEach(new LongProcedure(){

            public void value(long key) {
                LongBooleanHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongBooleanHashMap.isEmptyKey(key) && !LongBooleanHashMap.isRemovedKey(key);
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new BitSet(sizeToAllocate);
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        BitSet oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues.get(i));
        }
    }

    int probe(long element) {
        int index = this.spread(element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1L) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0L) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(long element) {
        long code = element;
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0L);
        this.values.clear();
    }

    public void put(long key, boolean value) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, value);
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(LongBooleanMap map) {
        map.forEachKeyValue(new LongBooleanProcedure(){

            public void value(long key, boolean value) {
                LongBooleanHashMap.this.put(key, value);
            }
        });
    }

    public boolean containsKey(long key) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(boolean value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || this.values.get(i) != value) continue;
            return true;
        }
        return false;
    }

    public boolean contains(boolean value) {
        return this.containsValue(value);
    }

    public boolean containsAll(boolean ... source) {
        for (boolean each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.allSatisfy(new BooleanPredicate(){

            public boolean accept(boolean value) {
                return LongBooleanHashMap.this.contains(value);
            }
        });
    }

    public boolean get(long key) {
        return this.getIfAbsent(key, false);
    }

    public boolean getIfAbsent(long key, boolean ifAbsent) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        return ifAbsent;
    }

    public boolean getOrThrow(long key) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongBooleanHashMap.isNonSentinel(this.keys[index])) {
            return this.values.get(index);
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean getIfAbsentPut(long key, boolean value) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPut(long key, BooleanFunction0 function) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> boolean getIfAbsentPutWith(long key, BooleanFunction<? super P> function, P parameter) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.booleanValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.booleanValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.booleanValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean getIfAbsentPutWithKey(long key, LongToBooleanFunction function) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                boolean value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            boolean value = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values.get(index);
        }
        boolean value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public boolean updateValue(long key, boolean initialValueIfAbsent, BooleanToBooleanFunction function) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values.set(index, function.valueOf(this.values.get(index)));
            return this.values.get(index);
        }
        boolean value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    private void addKeyValueAtIndex(long key, boolean value, int index) {
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values.set(index, value);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void removeKey(long key) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            this.values.set(index, false);
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(long key) {
        this.removeKey(key);
    }

    public boolean removeKeyIfAbsent(long key, boolean value) {
        if (LongBooleanHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (LongBooleanHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            boolean oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = false;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1L;
            boolean oldValue = this.values.get(index);
            this.values.set(index, false);
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongBooleanMap)) {
            return false;
        }
        LongBooleanMap other = (LongBooleanMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0L) || this.sentinelValues.zeroValue != other.getOrThrow(0L))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1L) || this.sentinelValues.oneValue != other.getOrThrow(1L))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongBooleanHashMap.isNonSentinel(key) || other.containsKey(key) && this.values.get(i) == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ (this.sentinelValues.zeroValue ? 1231 : 1237);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ (this.sentinelValues.oneValue ? 1231 : 1237);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ (this.values.get(i) ? 1231 : 1237);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0L)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1L)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongBooleanHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values.get(i)));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public BooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    public void forEach(BooleanProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void forEachValue(BooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values.get(i));
        }
    }

    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L);
            }
        }
        for (long key : this.keys) {
            if (!LongBooleanHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(LongBooleanProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values.get(i));
        }
    }

    public LongBooleanHashMap select(LongBooleanPredicate predicate) {
        LongBooleanHashMap result = new LongBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public LongBooleanHashMap reject(LongBooleanPredicate predicate) {
        LongBooleanHashMap result = new LongBooleanHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values.get(i))) continue;
            result.put(this.keys[i], this.values.get(i));
        }
        return result;
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values.get(i));
        }
        return result;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                long key = this.keys[i];
                if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values.get(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableBooleanCollection select(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        BooleanArrayList result = new BooleanArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            result.add(this.values.get(i));
        }
        return result;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return this.values.get(i);
        }
        return value;
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values.get(i)));
        }
        return target;
    }

    public int count(BooleanPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public boolean[] toArray() {
        boolean[] array = new boolean[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values.get(i);
            ++index;
        }
        return array;
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public RichIterable<LongBooleanPair> keyValuesView() {
        return new KeyValuesView();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        out.writeFloat(0.5f);
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeLong(0L);
                out.writeBoolean(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeLong(1L);
                out.writeBoolean(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongBooleanHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeBoolean(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        in.readFloat();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readBoolean());
        }
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableLongSet keySet() {
        return new KeySet();
    }

    public MutableBooleanCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ long[] access$902(LongBooleanHashMap x0, long[] x1) {
        x0.keys = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<LongBooleanPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super LongBooleanPair> procedure) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongBooleanHashMap.this.sentinelValues.zeroValue));
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongBooleanHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongBooleanHashMap.this.keys[i], LongBooleanHashMap.this.values.get(i)));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super LongBooleanPair> objectIntProcedure) {
            int index = 0;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0L, LongBooleanHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1L, LongBooleanHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(LongBooleanHashMap.this.keys[i], LongBooleanHashMap.this.values.get(i)), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super LongBooleanPair, ? super P> procedure, P parameter) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongBooleanHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongBooleanHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongBooleanHashMap.this.keys[i], LongBooleanHashMap.this.values.get(i)), parameter);
            }
        }

        public Iterator<LongBooleanPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<LongBooleanPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public LongBooleanPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (LongBooleanHashMap.this.containsKey(0L)) {
                        return PrimitiveTuples.pair(0L, LongBooleanHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (LongBooleanHashMap.this.containsKey(1L)) {
                        return PrimitiveTuples.pair(1L, LongBooleanHashMap.this.sentinelValues.oneValue);
                    }
                }
                long[] keys = LongBooleanHashMap.this.keys;
                while (!LongBooleanHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                LongBooleanPair result = PrimitiveTuples.pair(keys[this.position], LongBooleanHashMap.this.values.get(this.position));
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != LongBooleanHashMap.this.size();
            }
        }
    }

    private class KeySetIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < LongBooleanHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongBooleanHashMap.this.containsKey(0L)) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongBooleanHashMap.this.containsKey(1L)) {
                    return 1L;
                }
            }
            long[] keys = LongBooleanHashMap.this.keys;
            while (!LongBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            long result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableBooleanCollection {
        private ValuesCollection() {
        }

        public void clear() {
            LongBooleanHashMap.this.clear();
        }

        public MutableBooleanCollection select(BooleanPredicate predicate) {
            return LongBooleanHashMap.this.select(predicate);
        }

        public MutableBooleanCollection reject(BooleanPredicate predicate) {
            return LongBooleanHashMap.this.reject(predicate);
        }

        public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
            return LongBooleanHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
            return LongBooleanHashMap.this.collect(function);
        }

        public MutableBooleanCollection with(boolean element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection without(boolean element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection withAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection withoutAll(BooleanIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableBooleanCollection asSynchronized() {
            return SynchronizedBooleanCollection.of(this);
        }

        public MutableBooleanCollection asUnmodifiable() {
            return UnmodifiableBooleanCollection.of(this);
        }

        public ImmutableBooleanCollection toImmutable() {
            return BooleanLists.immutable.withAll((BooleanIterable)this);
        }

        public boolean contains(boolean value) {
            return LongBooleanHashMap.this.containsValue(value);
        }

        public boolean containsAll(boolean ... source) {
            return LongBooleanHashMap.this.containsAll(source);
        }

        public boolean containsAll(BooleanIterable source) {
            return LongBooleanHashMap.this.containsAll(source);
        }

        public MutableBooleanList toList() {
            return LongBooleanHashMap.this.toList();
        }

        public MutableBooleanSet toSet() {
            return LongBooleanHashMap.this.toSet();
        }

        public MutableBooleanBag toBag() {
            return LongBooleanHashMap.this.toBag();
        }

        public LazyBooleanIterable asLazy() {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }

        public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
            return LongBooleanHashMap.this.injectInto(injectedValue, function);
        }

        public boolean isEmpty() {
            return LongBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongBooleanHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongBooleanHashMap.this.sentinelValues != null) {
                    if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(LongBooleanHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(LongBooleanHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                    long key = LongBooleanHashMap.this.keys[i];
                    if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(LongBooleanHashMap.this.values.get(i)));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BooleanIterator booleanIterator() {
            return LongBooleanHashMap.this.booleanIterator();
        }

        public void forEach(BooleanProcedure procedure) {
            LongBooleanHashMap.this.forEach(procedure);
        }

        public int count(BooleanPredicate predicate) {
            return LongBooleanHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BooleanPredicate predicate) {
            return LongBooleanHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BooleanPredicate predicate) {
            return LongBooleanHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BooleanPredicate predicate) {
            return LongBooleanHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(boolean element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(boolean ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(BooleanIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(boolean item) {
            int oldSize = LongBooleanHashMap.this.size();
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && item == LongBooleanHashMap.this.sentinelValues.zeroValue) {
                    LongBooleanHashMap.this.removeKey(0L);
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && item == LongBooleanHashMap.this.sentinelValues.oneValue) {
                    LongBooleanHashMap.this.removeKey(1L);
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i]) || item != LongBooleanHashMap.this.values.get(i)) continue;
                LongBooleanHashMap.this.removeKey(LongBooleanHashMap.this.keys[i]);
            }
            return oldSize != LongBooleanHashMap.this.size();
        }

        public boolean removeAll(BooleanIterable source) {
            int oldSize = LongBooleanHashMap.this.size();
            BooleanIterator iterator = source.booleanIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != LongBooleanHashMap.this.size();
        }

        public boolean removeAll(boolean ... source) {
            int oldSize = LongBooleanHashMap.this.size();
            for (boolean item : source) {
                this.remove(item);
            }
            return oldSize != LongBooleanHashMap.this.size();
        }

        public boolean retainAll(BooleanIterable source) {
            int oldSize = LongBooleanHashMap.this.size();
            Object sourceSet = source instanceof BooleanSet ? (BooleanSet)source : source.toSet();
            LongBooleanHashMap retained = LongBooleanHashMap.this.select(new LongBooleanPredicate((BooleanSet)sourceSet){
                final /* synthetic */ BooleanSet val$sourceSet;
                {
                    this.val$sourceSet = booleanSet;
                }

                public boolean accept(long key, boolean value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                LongBooleanHashMap.access$902(LongBooleanHashMap.this, retained.keys);
                LongBooleanHashMap.this.values = retained.values;
                LongBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                LongBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(boolean ... source) {
            return this.retainAll((BooleanIterable)BooleanHashSet.newSetWith(source));
        }

        public int size() {
            return LongBooleanHashMap.this.size();
        }

        public boolean[] toArray() {
            return LongBooleanHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableLongSet {
        private KeySet() {
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongBooleanHashMap.this.forEachKey(procedure);
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return false;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(long element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(long ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(LongIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(long key) {
            int oldSize = LongBooleanHashMap.this.size();
            LongBooleanHashMap.this.removeKey(key);
            return oldSize != LongBooleanHashMap.this.size();
        }

        public boolean removeAll(LongIterable source) {
            int oldSize = LongBooleanHashMap.this.size();
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                LongBooleanHashMap.this.removeKey(iterator.next());
            }
            return oldSize != LongBooleanHashMap.this.size();
        }

        public boolean removeAll(long ... source) {
            int oldSize = LongBooleanHashMap.this.size();
            for (long item : source) {
                LongBooleanHashMap.this.removeKey(item);
            }
            return oldSize != LongBooleanHashMap.this.size();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = LongBooleanHashMap.this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            LongBooleanHashMap retained = LongBooleanHashMap.this.select(new LongBooleanPredicate((LongSet)sourceSet){
                final /* synthetic */ LongSet val$sourceSet;
                {
                    this.val$sourceSet = longSet;
                }

                public boolean accept(long key, boolean value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                LongBooleanHashMap.access$902(LongBooleanHashMap.this, retained.keys);
                LongBooleanHashMap.this.values = retained.values;
                LongBooleanHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongBooleanHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                LongBooleanHashMap.this.sentinelValues = retained.sentinelValues;
                return true;
            }
            return false;
        }

        public boolean retainAll(long ... source) {
            return this.retainAll((LongIterable)LongHashSet.newSetWith(source));
        }

        public void clear() {
            LongBooleanHashMap.this.clear();
        }

        public MutableLongSet select(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet reject(LongPredicate predicate) {
            LongHashSet result = new LongHashSet();
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    result.add(0L);
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    result.add(1L);
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableLongSet with(long element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet without(long element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableLongSet withoutAll(LongIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public long detectIfNone(LongPredicate predicate, long ifNone) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0L));
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1L));
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableLongSet asUnmodifiable() {
            return UnmodifiableLongSet.of(this);
        }

        public MutableLongSet asSynchronized() {
            return SynchronizedLongSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public long max() {
            if (LongBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long max = 0L;
            boolean isMaxSet = false;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0L;
                    isMaxSet = true;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1L)) {
                    max = 1L;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i]) || isMaxSet && max >= LongBooleanHashMap.this.keys[i]) continue;
                max = LongBooleanHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public long maxIfEmpty(long defaultValue) {
            if (LongBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public long min() {
            if (LongBooleanHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            long min = 0L;
            boolean isMinSet = false;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0L;
                    isMinSet = true;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1L < min)) {
                    min = 1L;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i]) || isMinSet && LongBooleanHashMap.this.keys[i] >= min) continue;
                min = LongBooleanHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (LongBooleanHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public long[] toArray() {
            int size = LongBooleanHashMap.this.size();
            final long[] result = new long[size];
            LongBooleanHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(long value) {
            return LongBooleanHashMap.this.containsKey(value);
        }

        public boolean containsAll(long ... source) {
            for (long item : source) {
                if (LongBooleanHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            LongIterator iterator = source.longIterator();
            while (iterator.hasNext()) {
                if (LongBooleanHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return new LazyLongIterableAdapter((LongIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0L);
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1L);
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, LongBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public LongSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableLongSet toImmutable() {
            return LongSets.immutable.withAll((LongIterable)this);
        }

        public int size() {
            return LongBooleanHashMap.this.size();
        }

        public boolean isEmpty() {
            return LongBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongBooleanHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LongSet)) {
                return false;
            }
            LongSet other = (LongSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i])) continue;
                result += (int)(LongBooleanHashMap.this.keys[i] ^ LongBooleanHashMap.this.keys[i] >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongBooleanHashMap.this.sentinelValues != null) {
                    if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongBooleanHashMap.this.keys) {
                    if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyLongIterable {
        private KeysView() {
        }

        public boolean isEmpty() {
            return LongBooleanHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return LongBooleanHashMap.this.notEmpty();
        }

        public int size() {
            return LongBooleanHashMap.this.size();
        }

        public boolean contains(long key) {
            return LongBooleanHashMap.this.containsKey(key);
        }

        public boolean containsAll(long ... keys) {
            for (long key : keys) {
                if (LongBooleanHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(LongIterable source) {
            return source.allSatisfy(new LongPredicate(){

                public boolean accept(long key) {
                    return LongBooleanHashMap.this.containsKey(key);
                }
            });
        }

        public LongIterator longIterator() {
            return new KeySetIterator();
        }

        public void forEach(LongProcedure procedure) {
            LongBooleanHashMap.this.forEachKey(procedure);
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (LongBooleanHashMap.this.sentinelValues != null) {
                    if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0L));
                        first = false;
                    }
                    if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1L));
                        first = false;
                    }
                }
                for (long key : LongBooleanHashMap.this.keys) {
                    if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public int count(LongPredicate predicate) {
            int count = 0;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    ++count;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    ++count;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(LongPredicate predicate) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return true;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return true;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(LongPredicate predicate) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0L)) {
                    return false;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1L)) {
                    return false;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(LongPredicate predicate) {
            return !this.anySatisfy(predicate);
        }

        public LazyLongIterable select(LongPredicate predicate) {
            return new SelectLongIterable((LongIterable)this, predicate);
        }

        public LazyLongIterable reject(LongPredicate predicate) {
            return new SelectLongIterable((LongIterable)this, LongPredicates.not(predicate));
        }

        public long detectIfNone(LongPredicate predicate, long value) {
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0L)) {
                    return 0L;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey && predicate.accept(1L)) {
                    return 1L;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(LongToObjectFunction<? extends V> function) {
            return new CollectLongToObjectIterable<V>((LongIterable)this, function);
        }

        public long sum() {
            long result = 0L;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0L;
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (long key : LongBooleanHashMap.this.keys) {
                if (!LongBooleanHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public long max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            LongIterator iterator = this.longIterator();
            long max = iterator.next();
            while (iterator.hasNext()) {
                long value = iterator.next();
                if (max >= value) continue;
                max = value;
            }
            return max;
        }

        public long min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            LongIterator iterator = this.longIterator();
            long min = iterator.next();
            while (iterator.hasNext()) {
                long value = iterator.next();
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        public long minIfEmpty(long defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public long maxIfEmpty(long defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            long[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                long first = sortedArray[middleIndex];
                long second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public long[] toSortedArray() {
            long[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public long[] toArray() {
            int size = LongBooleanHashMap.this.size();
            final long[] result = new long[size];
            LongBooleanHashMap.this.forEachKey(new LongProcedure(){
                private int index;

                public void value(long each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (LongBooleanHashMap.this.sentinelValues != null) {
                if (LongBooleanHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0L);
                }
                if (LongBooleanHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1L);
                }
            }
            for (int i = 0; i < LongBooleanHashMap.this.keys.length; ++i) {
                if (!LongBooleanHashMap.isNonSentinel(LongBooleanHashMap.this.keys[i])) continue;
                result = function.valueOf(result, LongBooleanHashMap.this.keys[i]);
            }
            return result;
        }

        public MutableLongList toList() {
            return LongArrayList.newList((LongIterable)this);
        }

        public MutableLongList toSortedList() {
            return LongArrayList.newList((LongIterable)this).sortThis();
        }

        public MutableLongSet toSet() {
            return LongHashSet.newSet((LongIterable)this);
        }

        public MutableLongBag toBag() {
            return LongHashBag.newBag((LongIterable)this);
        }

        public LazyLongIterable asLazy() {
            return this;
        }
    }

    private class InternalBooleanIterator
    implements BooleanIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return this.count < LongBooleanHashMap.this.size();
        }

        public boolean next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongBooleanHashMap.this.containsKey(0L)) {
                    return LongBooleanHashMap.this.sentinelValues.zeroValue;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongBooleanHashMap.this.containsKey(1L)) {
                    return LongBooleanHashMap.this.sentinelValues.oneValue;
                }
            }
            long[] keys = LongBooleanHashMap.this.keys;
            while (!LongBooleanHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            boolean result = LongBooleanHashMap.this.values.get(this.position);
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private boolean zeroValue;
        private boolean oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(boolean value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

