/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableDoubleStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableDoubleArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableDoubleEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableDoubleSingletonStack;

public class ImmutableDoubleStackFactoryImpl
implements ImmutableDoubleStackFactory {
    public ImmutableDoubleStack of() {
        return this.with();
    }

    public ImmutableDoubleStack with() {
        return ImmutableDoubleEmptyStack.INSTANCE;
    }

    public ImmutableDoubleStack of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleStack with(double one) {
        return new ImmutableDoubleSingletonStack(one);
    }

    public ImmutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleStack with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayStack.newStackWith(items);
    }

    public ImmutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleStack withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleStack) {
            return (ImmutableDoubleStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableDoubleArrayStack.newStackFromTopToBottom(items);
    }
}

