/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityEventCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AnnouncementEventCheck;
import com.google.android.apps.common.testing.accessibility.framework.ClickableSpanInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.ClickableSpanViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateClickableBoundsInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateClickableBoundsViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.DuplicateSpeakableTextViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.EditableContentDescInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.EditableContentDescViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.RedundantContentDescInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.RedundantContentDescViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.SpeakableTextPresentInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.SpeakableTextPresentViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TextContrastViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.TouchTargetSizeInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.TouchTargetSizeViewCheck;
import java.util.HashSet;
import java.util.Set;

public enum AccessibilityCheckPreset {
    LATEST,
    VERSION_1_0_CHECKS,
    VERSION_2_0_CHECKS,
    NO_CHECKS,
    PRERELEASE;


    public static Set<AccessibilityViewHierarchyCheck> getViewChecksForPreset(AccessibilityCheckPreset preset) {
        HashSet<AccessibilityViewHierarchyCheck> checks = new HashSet<AccessibilityViewHierarchyCheck>();
        if (preset == NO_CHECKS) {
            return checks;
        }
        checks.add(new TouchTargetSizeViewCheck());
        checks.add(new TextContrastViewCheck());
        checks.add(new DuplicateSpeakableTextViewHierarchyCheck());
        checks.add(new SpeakableTextPresentViewCheck());
        checks.add(new EditableContentDescViewCheck());
        if (preset == VERSION_1_0_CHECKS) {
            return checks;
        }
        checks.add(new ClickableSpanViewCheck());
        checks.add(new RedundantContentDescViewCheck());
        checks.add(new DuplicateClickableBoundsViewCheck());
        if (preset == VERSION_2_0_CHECKS) {
            return checks;
        }
        if (preset == LATEST) {
            return checks;
        }
        if (preset == PRERELEASE) {
            return checks;
        }
        throw new IllegalArgumentException();
    }

    public static Set<AccessibilityInfoHierarchyCheck> getInfoChecksForPreset(AccessibilityCheckPreset preset) {
        HashSet<AccessibilityInfoHierarchyCheck> checks = new HashSet<AccessibilityInfoHierarchyCheck>();
        if (preset == NO_CHECKS) {
            return checks;
        }
        checks.add(new EditableContentDescInfoCheck());
        checks.add(new SpeakableTextPresentInfoCheck());
        if (preset == VERSION_1_0_CHECKS) {
            return checks;
        }
        checks.add(new ClickableSpanInfoCheck());
        checks.add(new TouchTargetSizeInfoCheck());
        checks.add(new RedundantContentDescInfoCheck());
        checks.add(new DuplicateClickableBoundsInfoCheck());
        if (preset == VERSION_2_0_CHECKS) {
            return checks;
        }
        if (preset == LATEST) {
            return checks;
        }
        if (preset == PRERELEASE) {
            return checks;
        }
        throw new IllegalArgumentException();
    }

    public static Set<AccessibilityEventCheck> getEventChecksForPreset(AccessibilityCheckPreset preset) {
        HashSet<AccessibilityEventCheck> checks = new HashSet<AccessibilityEventCheck>();
        if (preset == NO_CHECKS || preset == VERSION_1_0_CHECKS) {
            return checks;
        }
        checks.add(new AnnouncementEventCheck());
        if (preset == VERSION_2_0_CHECKS) {
            return checks;
        }
        if (preset == LATEST) {
            return checks;
        }
        if (preset == PRERELEASE) {
            return checks;
        }
        throw new IllegalArgumentException();
    }
}

