/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;

public abstract class AccessibilityCheckResult {
    protected Class<? extends AccessibilityCheck> checkClass;
    protected AccessibilityCheckResultType type;
    protected CharSequence message;

    public AccessibilityCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResultType type, CharSequence message) {
        this.checkClass = checkClass;
        this.type = type;
        this.message = message;
    }

    public Class<? extends AccessibilityCheck> getSourceCheckClass() {
        return this.checkClass;
    }

    public AccessibilityCheckResultType getType() {
        return this.type;
    }

    void setType(AccessibilityCheckResultType type) {
        this.type = type;
    }

    public CharSequence getMessage() {
        return this.message;
    }

    public void recycle() {
        this.checkClass = null;
        this.type = null;
        this.message = null;
    }

    public static class AccessibilityCheckResultDescriptor {
        public String describeResult(AccessibilityCheckResult result) {
            StringBuilder message = new StringBuilder();
            if (result instanceof AccessibilityViewCheckResult) {
                message.append(this.describeView(((AccessibilityViewCheckResult)result).getView()));
                message.append(": ");
            } else if (result instanceof AccessibilityInfoCheckResult) {
                message.append(this.describeInfo(((AccessibilityInfoCheckResult)result).getInfo()));
                message.append(": ");
            }
            message.append(result.getMessage());
            return message.toString();
        }

        public String describeView(View view) {
            StringBuilder message = new StringBuilder();
            if (view != null && view.getId() != -1 && view.getResources() != null) {
                message.append("View ");
                message.append(view.getResources().getResourceEntryName(view.getId()));
            } else {
                message.append("View with no valid resource name");
            }
            return message.toString();
        }

        public String describeInfo(AccessibilityNodeInfo info) {
            StringBuilder message = new StringBuilder();
            message.append("View ");
            if (Build.VERSION.SDK_INT >= 18 && info != null && info.getViewIdResourceName() != null) {
                message.append(info.getViewIdResourceName());
            } else {
                message.append("with bounds: ");
                Rect bounds = new Rect();
                info.getBoundsInScreen(bounds);
                message.append(bounds.toShortString());
            }
            return message.toString();
        }
    }

    public static enum AccessibilityCheckResultType {
        ERROR,
        WARNING,
        INFO,
        NOT_RUN,
        SUPPRESSED;

    }
}

