/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class AccessibilityCheckResultUtils {
    private AccessibilityCheckResultUtils() {
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForCheck(Iterable<T> results, Class<? extends AccessibilityCheck> checkClass) {
        ArrayList<AccessibilityCheckResult> resultsForCheck = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            if (!checkClass.equals(result.getSourceCheckClass())) continue;
            resultsForCheck.add(result);
        }
        return resultsForCheck;
    }

    public static <T extends AccessibilityCheckResult> List<T> getResultsForType(Iterable<T> results, AccessibilityCheckResult.AccessibilityCheckResultType type) {
        ArrayList<AccessibilityCheckResult> resultsForType = new ArrayList<AccessibilityCheckResult>();
        for (AccessibilityCheckResult result : results) {
            if (result.getType() != type) continue;
            resultsForType.add(result);
        }
        return resultsForType;
    }

    public static List<AccessibilityViewCheckResult> getResultsForView(Iterable<AccessibilityViewCheckResult> results, View view) {
        ArrayList<AccessibilityViewCheckResult> resultsForView = new ArrayList<AccessibilityViewCheckResult>();
        for (AccessibilityViewCheckResult result : results) {
            if (result.getView() != view) continue;
            resultsForView.add(result);
        }
        return resultsForView;
    }

    public static List<AccessibilityInfoCheckResult> getResultsForInfo(Iterable<AccessibilityInfoCheckResult> results, AccessibilityNodeInfo info) {
        ArrayList<AccessibilityInfoCheckResult> resultsForInfo = new ArrayList<AccessibilityInfoCheckResult>();
        for (AccessibilityInfoCheckResult result : results) {
            if (!info.equals((Object)result.getInfo())) continue;
            resultsForInfo.add(result);
        }
        return resultsForInfo;
    }

    public static Matcher<AccessibilityCheckResult> matchesTypes(final Matcher<? super AccessibilityCheckResult.AccessibilityCheckResultType> typeMatcher) {
        if (typeMatcher == null) {
            return null;
        }
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("result type", typeMatcher){

            public boolean matchesSafely(AccessibilityCheckResult result) {
                return typeMatcher.matches((Object)result.getType());
            }
        };
    }

    public static Matcher<AccessibilityCheckResult> matchesCheckNames(final Matcher<? super String> classNameMatcher) {
        if (classNameMatcher == null) {
            return null;
        }
        return new TypeSafeMemberMatcher<AccessibilityCheckResult>("source check name", classNameMatcher){

            public boolean matchesSafely(AccessibilityCheckResult result) {
                return classNameMatcher.matches((Object)result.getSourceCheckClass().getSimpleName());
            }
        };
    }

    public static Matcher<AccessibilityViewCheckResult> matchesViews(final Matcher<? super View> viewMatcher) {
        if (viewMatcher == null) {
            return null;
        }
        return new TypeSafeMemberMatcher<AccessibilityViewCheckResult>("View", viewMatcher){

            public boolean matchesSafely(AccessibilityViewCheckResult result) {
                return viewMatcher.matches((Object)result.getView());
            }
        };
    }

    public static Matcher<AccessibilityInfoCheckResult> matchesInfos(final Matcher<? super AccessibilityNodeInfo> infoMatcher) {
        if (infoMatcher == null) {
            return null;
        }
        return new TypeSafeMemberMatcher<AccessibilityInfoCheckResult>("AccessibilityNodeInfo", infoMatcher){

            public boolean matchesSafely(AccessibilityInfoCheckResult result) {
                return infoMatcher.matches((Object)result.getInfo());
            }
        };
    }

    public static <T extends AccessibilityCheckResult> void suppressMatchingResults(List<T> results, Matcher<? super T> matcher) {
        AccessibilityCheckResultUtils.modifyResultType(results, matcher, AccessibilityCheckResult.AccessibilityCheckResultType.SUPPRESSED);
    }

    private static <T extends AccessibilityCheckResult> void modifyResultType(List<T> results, Matcher<? super T> matcher, AccessibilityCheckResult.AccessibilityCheckResultType newType) {
        if (results == null || matcher == null) {
            return;
        }
        for (AccessibilityCheckResult result : results) {
            if (!matcher.matches((Object)result)) continue;
            result.setType(newType);
        }
    }

    private static abstract class TypeSafeMemberMatcher<T>
    extends TypeSafeMatcher<T> {
        private static final String DESCRIPTION_FORMAT_STRING = "with %s: ";
        private String memberDescription;
        private Matcher<?> matcher;

        public TypeSafeMemberMatcher(String member, Matcher<?> matcher) {
            this.memberDescription = String.format(DESCRIPTION_FORMAT_STRING, member);
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText(this.memberDescription);
            this.matcher.describeTo(description);
        }
    }
}

