/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.os.Build;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;
import com.googlecode.eyesfree.utils.StringBuilderUtils;
import java.util.HashSet;

final class AccessibilityCheckUtils {
    private AccessibilityCheckUtils() {
    }

    static CharSequence getSpeakableTextForInfo(AccessibilityNodeInfo info) {
        AccessibilityNodeInfo labeledBy;
        if (info == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT > 16 && (labeledBy = info.getLabeledBy()) != null) {
            HashSet<AccessibilityNodeInfo> infosVisited = new HashSet<AccessibilityNodeInfo>();
            infosVisited.add(info);
            infosVisited.add(labeledBy);
            AccessibilityNodeInfo endOfLabeledByChain = labeledBy.getLabeledBy();
            while (endOfLabeledByChain != null) {
                if (infosVisited.contains(endOfLabeledByChain)) {
                    infosVisited.remove(info);
                    for (AccessibilityNodeInfo infoVisited : infosVisited) {
                        infoVisited.recycle();
                    }
                    return null;
                }
                infosVisited.add(endOfLabeledByChain);
                labeledBy = endOfLabeledByChain;
                endOfLabeledByChain = labeledBy.getLabeledBy();
            }
            CharSequence labelText = AccessibilityCheckUtils.getSpeakableTextForInfo(labeledBy);
            infosVisited.remove(info);
            for (AccessibilityNodeInfo infoVisited : infosVisited) {
                infoVisited.recycle();
            }
            return labelText;
        }
        AccessibilityNodeInfoCompat compat = new AccessibilityNodeInfoCompat((Object)info);
        CharSequence nodeText = AccessibilityNodeInfoUtils.getNodeText(compat);
        StringBuilder returnStringBuilder = new StringBuilder(nodeText == null ? "" : nodeText);
        if (TextUtils.isEmpty((CharSequence)compat.getContentDescription())) {
            for (int i = 0; i < compat.getChildCount(); ++i) {
                AccessibilityNodeInfoCompat child = compat.getChild(i);
                if (!AccessibilityNodeInfoUtils.isVisibleOrLegacy(child) || AccessibilityNodeInfoUtils.isActionableForAccessibility(child)) continue;
                returnStringBuilder.append(AccessibilityCheckUtils.getSpeakableTextForInfo((AccessibilityNodeInfo)child.getInfo()));
            }
        }
        return returnStringBuilder;
    }

    static CharSequence getSpeakableTextForView(View view) {
        if (view == null) {
            return null;
        }
        View labelForThisView = ViewAccessibilityUtils.getLabelForView(view);
        if (labelForThisView != null) {
            return AccessibilityCheckUtils.getSpeakableTextForView(labelForThisView);
        }
        SpannableStringBuilder returnStringBuilder = new SpannableStringBuilder((CharSequence)"");
        if (Build.VERSION.SDK_INT < 16 || ViewAccessibilityUtils.isImportantForAccessibility(view)) {
            if (!TextUtils.isEmpty((CharSequence)view.getContentDescription())) {
                return view.getContentDescription();
            }
            if (view instanceof TextView) {
                if (!TextUtils.isEmpty((CharSequence)((TextView)view).getText())) {
                    returnStringBuilder.append(((TextView)view).getText());
                } else if (!TextUtils.isEmpty((CharSequence)((TextView)view).getHint())) {
                    returnStringBuilder.append(((TextView)view).getHint());
                }
            }
        }
        if (view instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)view;
            for (int i = 0; i < group.getChildCount(); ++i) {
                View childView = group.getChildAt(i);
                if (childView.getVisibility() != 0 || ViewAccessibilityUtils.isActionableForAccessibility(childView)) continue;
                returnStringBuilder.append(AccessibilityCheckUtils.getSpeakableTextForView(childView));
            }
        }
        if (view instanceof CompoundButton) {
            if (((CompoundButton)view).isChecked()) {
                StringBuilderUtils.appendWithSeparator(returnStringBuilder, "Checked");
            } else {
                StringBuilderUtils.appendWithSeparator(returnStringBuilder, "Not checked");
            }
        }
        return returnStringBuilder;
    }
}

