/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.annotation.TargetApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.googlecode.eyesfree.utils.LogUtils;

@TargetApi(value=4)
public final class AccessibilityEventCheckResult
extends AccessibilityCheckResult
implements Parcelable {
    private AccessibilityEvent event;
    public static final Parcelable.Creator<AccessibilityEventCheckResult> CREATOR = new Parcelable.Creator<AccessibilityEventCheckResult>(){

        public AccessibilityEventCheckResult createFromParcel(Parcel in) {
            return new AccessibilityEventCheckResult(in);
        }

        public AccessibilityEventCheckResult[] newArray(int size) {
            return new AccessibilityEventCheckResult[size];
        }
    };

    public AccessibilityEventCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, CharSequence message, AccessibilityEvent event) {
        super(checkClass, type, message);
        if (event != null) {
            this.event = AccessibilityEvent.obtain((AccessibilityEvent)event);
        }
    }

    private AccessibilityEventCheckResult(Parcel in) {
        super(null, null, null);
        this.readFromParcel(in);
    }

    public AccessibilityEvent getEvent() {
        return this.event;
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.event != null) {
            this.event.recycle();
            this.event = null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.checkClass != null ? this.checkClass.getName() : "");
        dest.writeInt(this.type != null ? this.type.ordinal() : -1);
        TextUtils.writeToParcel((CharSequence)this.message, (Parcel)dest, (int)flags);
        if (this.event != null) {
            dest.writeInt(1);
            this.event.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    private void readFromParcel(Parcel in) {
        int type;
        this.checkClass = null;
        String checkClassName = in.readString();
        if (!"".equals(checkClassName)) {
            try {
                Class<?> uncheckedClass = Class.forName(checkClassName);
                if (AccessibilityCheck.class.isAssignableFrom(uncheckedClass)) {
                    this.checkClass = uncheckedClass;
                }
            }
            catch (ClassNotFoundException e) {
                LogUtils.log(this, 5, "Attempt to obtain unknown class %1$s", checkClassName);
            }
        }
        this.type = (type = in.readInt()) != -1 ? AccessibilityCheckResult.AccessibilityCheckResultType.values()[type] : null;
        this.message = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.event = in.readInt() == 1 ? (AccessibilityEvent)AccessibilityEvent.CREATOR.createFromParcel(in) : null;
    }
}

