/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.annotation.TargetApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.googlecode.eyesfree.utils.LogUtils;

@TargetApi(value=14)
public final class AccessibilityInfoCheckResult
extends AccessibilityCheckResult
implements Parcelable {
    private AccessibilityNodeInfo info;
    public static final Parcelable.Creator<AccessibilityInfoCheckResult> CREATOR = new Parcelable.Creator<AccessibilityInfoCheckResult>(){

        public AccessibilityInfoCheckResult createFromParcel(Parcel in) {
            return new AccessibilityInfoCheckResult(in);
        }

        public AccessibilityInfoCheckResult[] newArray(int size) {
            return new AccessibilityInfoCheckResult[size];
        }
    };

    public AccessibilityInfoCheckResult(Class<? extends AccessibilityCheck> checkClass, AccessibilityCheckResult.AccessibilityCheckResultType type, CharSequence message, AccessibilityNodeInfo info) {
        super(checkClass, type, message);
        if (info != null) {
            this.info = AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)info);
        }
    }

    private AccessibilityInfoCheckResult(Parcel in) {
        super(null, null, null);
        this.readFromParcel(in);
    }

    public AccessibilityNodeInfo getInfo() {
        return this.info;
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.info != null) {
            this.info.recycle();
            this.info = null;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.checkClass != null ? this.checkClass.getName() : "");
        dest.writeInt(this.type != null ? this.type.ordinal() : -1);
        TextUtils.writeToParcel((CharSequence)this.message, (Parcel)dest, (int)flags);
        if (this.info != null) {
            dest.writeInt(1);
            this.info.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    private void readFromParcel(Parcel in) {
        int type;
        this.checkClass = null;
        String checkClassName = in.readString();
        if (!"".equals(checkClassName)) {
            try {
                Class<?> uncheckedClass = Class.forName(checkClassName);
                if (AccessibilityCheck.class.isAssignableFrom(uncheckedClass)) {
                    this.checkClass = uncheckedClass;
                }
            }
            catch (ClassNotFoundException e) {
                LogUtils.log(this, 5, "Attempt to obtain unknown class %1$s", checkClassName);
            }
        }
        this.type = (type = in.readInt()) != -1 ? AccessibilityCheckResult.AccessibilityCheckResultType.values()[type] : null;
        this.message = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.info = in.readInt() == 1 ? (AccessibilityNodeInfo)AccessibilityNodeInfo.CREATOR.createFromParcel(in) : null;
    }
}

