/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;
import java.util.ArrayList;
import java.util.List;

public class ClickableSpanInfoCheck
extends AccessibilityInfoCheck {
    @Override
    public List<AccessibilityInfoCheckResult> runCheckOnInfo(AccessibilityNodeInfo info, Context context, Bundle metadata) {
        ArrayList<AccessibilityInfoCheckResult> results = new ArrayList<AccessibilityInfoCheckResult>(1);
        AccessibilityNodeInfoCompat compatInfo = new AccessibilityNodeInfoCompat((Object)info);
        if (AccessibilityNodeInfoUtils.nodeMatchesAnyClassByType(context, compatInfo, TextView.class)) {
            if (info.getText() instanceof Spanned) {
                ClickableSpan[] clickableSpans;
                Spanned text = (Spanned)info.getText();
                for (ClickableSpan clickableSpan : clickableSpans = (ClickableSpan[])text.getSpans(0, text.length(), ClickableSpan.class)) {
                    if (clickableSpan instanceof URLSpan) {
                        String url = ((URLSpan)clickableSpan).getURL();
                        if (url == null) {
                            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "URLSpan has null URL", info));
                            continue;
                        }
                        Uri uri = Uri.parse((String)url);
                        if (!uri.isRelative()) continue;
                        results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "URLSpan should not contain relative links", info));
                        continue;
                    }
                    results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "URLSpan should be used in place of ClickableSpan for improved accessibility", info));
                }
            }
        } else {
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View must be a TextView", info));
        }
        return results;
    }
}

