/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.net.Uri;
import android.text.Spanned;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import java.util.ArrayList;
import java.util.List;

public class ClickableSpanViewCheck
extends AccessibilityViewCheck {
    @Override
    public List<AccessibilityViewCheckResult> runCheckOnView(View view) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>(1);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            if (textView.getText() instanceof Spanned) {
                ClickableSpan[] clickableSpans;
                Spanned text = (Spanned)textView.getText();
                for (ClickableSpan clickableSpan : clickableSpans = (ClickableSpan[])text.getSpans(0, text.length(), ClickableSpan.class)) {
                    if (clickableSpan instanceof URLSpan) {
                        String url = ((URLSpan)clickableSpan).getURL();
                        if (url == null) {
                            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "URLSpan has null URL", view));
                            continue;
                        }
                        Uri uri = Uri.parse((String)url);
                        if (!uri.isRelative()) continue;
                        results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "URLSpan should not contain relative links", view));
                        continue;
                    }
                    results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "URLSpan should be used in place of ClickableSpan for improved accessibility", view));
                }
            }
        } else {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View must be a TextView", view));
        }
        return results;
    }
}

