/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoHierarchyCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DuplicateClickableBoundsInfoCheck
extends AccessibilityInfoHierarchyCheck {
    @Override
    public List<AccessibilityInfoCheckResult> runCheckOnInfoHierarchy(AccessibilityNodeInfo root, Context context, Bundle metadata) {
        ArrayList<AccessibilityInfoCheckResult> results = new ArrayList<AccessibilityInfoCheckResult>(1);
        HashMap<Rect, AccessibilityNodeInfo> clickableRectToInfoMap = new HashMap<Rect, AccessibilityNodeInfo>();
        this.checkForDuplicateClickableViews(root, clickableRectToInfoMap, results);
        for (AccessibilityNodeInfo info : clickableRectToInfoMap.values()) {
            info.recycle();
        }
        return results;
    }

    private void checkForDuplicateClickableViews(AccessibilityNodeInfo root, Map<Rect, AccessibilityNodeInfo> clickableRectToInfoMap, List<AccessibilityInfoCheckResult> results) {
        if (root.isClickable() && root.isVisibleToUser()) {
            Rect bounds = new Rect();
            root.getBoundsInScreen(bounds);
            if (clickableRectToInfoMap.containsKey(bounds)) {
                results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "Clickable view has same bounds as another clickable view (likely a descendent)", clickableRectToInfoMap.get(bounds)));
            } else {
                clickableRectToInfoMap.put(bounds, AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)root));
            }
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            AccessibilityNodeInfo child = root.getChild(i);
            this.checkForDuplicateClickableViews(child, clickableRectToInfoMap, results);
            child.recycle();
        }
    }
}

