/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DuplicateClickableBoundsViewCheck
extends AccessibilityViewHierarchyCheck {
    @Override
    public List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View root) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>(1);
        if (Build.VERSION.SDK_INT < 16) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check only runs on Android 2.3.3 and above.", root));
            return results;
        }
        HashMap<Rect, View> clickableRectToViewMap = new HashMap<Rect, View>();
        this.checkForDuplicateClickableViews(root, clickableRectToViewMap, results);
        return results;
    }

    private void checkForDuplicateClickableViews(View root, Map<Rect, View> clickableRectToViewMap, List<AccessibilityViewCheckResult> results) {
        Rect bounds;
        if (!ViewAccessibilityUtils.isVisibleToUser(root)) {
            return;
        }
        if (root.isClickable() && ViewAccessibilityUtils.isImportantForAccessibility(root) && root.getGlobalVisibleRect(bounds = new Rect())) {
            if (clickableRectToViewMap.containsKey(bounds)) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "Clickable view has same bounds as another clickable view (likely a descendent)", clickableRectToViewMap.get(bounds)));
            } else {
                clickableRectToViewMap.put(bounds, root);
            }
        }
        if (!(root instanceof ViewGroup)) {
            return;
        }
        ViewGroup viewGroup = (ViewGroup)root;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            this.checkForDuplicateClickableViews(child, clickableRectToViewMap, results);
        }
    }
}

