/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DuplicateSpeakableTextViewHierarchyCheck
extends AccessibilityViewHierarchyCheck {
    @Override
    public List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View root) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>();
        if (Build.VERSION.SDK_INT < 16) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check only runs on Andorid 4.1 and above.", root));
            return results;
        }
        Set<View> allViews = ViewAccessibilityUtils.getAllViewsInHierarchy(root);
        Map<String, List<View>> textToViewMap = this.getSpeakableTextToViewMap(allViews);
        for (String speakableText : textToViewMap.keySet()) {
            if (textToViewMap.get(speakableText).size() < 2) continue;
            ArrayList<View> clickableViews = new ArrayList<View>();
            ArrayList<View> nonClickableViews = new ArrayList<View>();
            for (View view : textToViewMap.get(speakableText)) {
                if (view.isClickable()) {
                    clickableViews.add(view);
                    continue;
                }
                nonClickableViews.add(view);
            }
            if (clickableViews.size() > 0) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, String.format(Locale.US, "Clickable view's speakable text: \"%s\" is identical to that of %d other view(s)", speakableText, nonClickableViews.size()), (View)clickableViews.get(0)));
                clickableViews.remove(0);
            } else {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.INFO, String.format(Locale.US, "Non-clickable view's speakable text: \"%s\" is identical to that of %d other non-clickable view(s)", speakableText, nonClickableViews.size() - 1), (View)nonClickableViews.get(0)));
                nonClickableViews.remove(0);
            }
            for (View clickableView : clickableViews) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.INFO, String.format("  Clickable View has speakable text: \"%s\".", speakableText), clickableView));
            }
            for (View clickableView : nonClickableViews) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.INFO, String.format("  Non-clickable View has speakable text: \"%s\".", speakableText), clickableView));
            }
        }
        if (textToViewMap.size() == 0) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "No Views in hierarchy have speakable text", root));
            return results;
        }
        return results;
    }

    private Map<String, List<View>> getSpeakableTextToViewMap(Set<View> allViews) {
        HashMap<String, List<View>> textToViewMap = new HashMap<String, List<View>>();
        for (View view : allViews) {
            String speakableText = AccessibilityCheckUtils.getSpeakableTextForView(view).toString().trim();
            if (TextUtils.isEmpty((CharSequence)speakableText)) continue;
            if (!textToViewMap.containsKey(speakableText)) {
                textToViewMap.put(speakableText, new ArrayList());
            }
            ((List)textToViewMap.get(speakableText)).add(view);
        }
        return textToViewMap;
    }
}

