/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.EditText;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;
import java.util.ArrayList;
import java.util.List;

public class EditableContentDescInfoCheck
extends AccessibilityInfoCheck {
    @Override
    public List<AccessibilityInfoCheckResult> runCheckOnInfo(AccessibilityNodeInfo info, Context context, Bundle metadata) {
        ArrayList<AccessibilityInfoCheckResult> results = new ArrayList<AccessibilityInfoCheckResult>(1);
        AccessibilityNodeInfoCompat compatInfo = new AccessibilityNodeInfoCompat((Object)info);
        if (Build.VERSION.SDK_INT >= 18) {
            if (info.isEditable()) {
                if (!TextUtils.isEmpty((CharSequence)info.getContentDescription())) {
                    results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "Editable view should not have a contentDescription", info));
                }
            } else {
                results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "Associated view must be editable", info));
            }
        } else if (AccessibilityNodeInfoUtils.nodeMatchesAnyClassByType(null, compatInfo, EditText.class)) {
            if (!TextUtils.isEmpty((CharSequence)compatInfo.getContentDescription())) {
                results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "EditText should not have a contentDescription", info));
            }
        } else {
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "Associated view must be an EditText", info));
        }
        return results;
    }
}

