/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import java.util.ArrayList;
import java.util.List;

public class EditableContentDescViewCheck
extends AccessibilityViewCheck {
    @Override
    public List<AccessibilityViewCheckResult> runCheckOnView(View view) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>(1);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            if (textView.getEditableText() != null) {
                if (!TextUtils.isEmpty((CharSequence)textView.getContentDescription())) {
                    results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "Editable TextView should not have a contentDescription.", (View)textView));
                }
            } else {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "TextView must be editable", (View)textView));
            }
        } else {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View must be a TextView", view));
        }
        return results;
    }
}

