/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.TextUtils;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoHierarchyCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RedundantContentDescInfoCheck
extends AccessibilityInfoHierarchyCheck {
    private static List<CharSequence> redundantWords = new ArrayList<CharSequence>();

    @Override
    public List<AccessibilityInfoCheckResult> runCheckOnInfoHierarchy(AccessibilityNodeInfo root, Context context, Bundle metadata) {
        ArrayList<AccessibilityInfoCheckResult> results = new ArrayList<AccessibilityInfoCheckResult>();
        if (!Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check only runs in English locales", root));
            return results;
        }
        List<AccessibilityNodeInfoCompat> compatInfos = RedundantContentDescInfoCheck.getAllInfoCompatsInHierarchy(context, root);
        block0: for (AccessibilityNodeInfoCompat compatInfo : compatInfos) {
            AccessibilityNodeInfo info = (AccessibilityNodeInfo)compatInfo.getInfo();
            CharSequence contentDescription = info.getContentDescription();
            if (TextUtils.isEmpty((CharSequence)contentDescription)) {
                results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View has no content description", info));
                continue;
            }
            for (CharSequence redundantWord : redundantWords) {
                if (!contentDescription.toString().toLowerCase().contains(redundantWord)) continue;
                results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, "View's speakable text ends with view type", info));
                continue block0;
            }
        }
        return results;
    }

    static {
        redundantWords.add("button");
    }
}

