/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RedundantContentDescViewCheck
extends AccessibilityViewHierarchyCheck {
    private static List<CharSequence> redundantWords = new ArrayList<CharSequence>();

    @Override
    public List<AccessibilityViewCheckResult> runCheckOnViewHierarchy(View root) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>();
        if (Build.VERSION.SDK_INT < 16) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check only runs on Android 4.1 and above.", root));
            return results;
        }
        if (!Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check only runs in English locales", root));
            return results;
        }
        for (View view : ViewAccessibilityUtils.getAllViewsInHierarchy(root)) {
            if (!ViewAccessibilityUtils.isImportantForAccessibility(view)) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not important for accessibility", view));
                continue;
            }
            CharSequence contentDescription = view.getContentDescription();
            if (TextUtils.isEmpty((CharSequence)contentDescription)) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View has no content description", view));
                continue;
            }
            for (CharSequence redundantWord : redundantWords) {
                if (!contentDescription.toString().toLowerCase().contains(redundantWord)) continue;
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, "View's speakable text ends with view type", view));
            }
        }
        return results;
    }

    static {
        redundantWords.add("button");
    }
}

