/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.webkit.WebView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityInfoCheckResult;
import com.googlecode.eyesfree.utils.AccessibilityNodeInfoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpeakableTextPresentInfoCheck
extends AccessibilityInfoCheck {
    private static List<Class<? extends ViewGroup>> blacklistedViewTypes = Arrays.asList(ListView.class, ScrollView.class, ViewPager.class, WebView.class);

    @Override
    public List<AccessibilityInfoCheckResult> runCheckOnInfo(AccessibilityNodeInfo info, Context context, Bundle metadata) {
        ArrayList<AccessibilityInfoCheckResult> results = new ArrayList<AccessibilityInfoCheckResult>();
        AccessibilityNodeInfoCompat compatInfo = new AccessibilityNodeInfoCompat((Object)info);
        for (Class<? extends ViewGroup> clazz : blacklistedViewTypes) {
            if (!AccessibilityNodeInfoUtils.nodeMatchesAnyClassByType(null, compatInfo, clazz)) continue;
            String msg = String.format("Views of type %s are not checked for speakable text.", clazz.getName());
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, msg, info));
            return results;
        }
        if (AccessibilityNodeInfoUtils.shouldFocusNode(context, compatInfo)) {
            if (TextUtils.isEmpty((CharSequence)AccessibilityCheckUtils.getSpeakableTextForInfo(info))) {
                results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "View is missing speakable text needed for a screen reader", info));
            }
        } else {
            results.add(new AccessibilityInfoCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not focused by screen readers", info));
        }
        return results;
    }
}

