/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import android.os.Build;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ListView;
import android.widget.ScrollView;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpeakableTextPresentViewCheck
extends AccessibilityViewCheck {
    private static final List<Class<? extends ViewGroup>> blacklistedViewTypes = Arrays.asList(ListView.class, ScrollView.class, ViewPager.class, WebView.class);

    @Override
    public List<AccessibilityViewCheckResult> runCheckOnView(View view) {
        ArrayList<AccessibilityViewCheckResult> results = new ArrayList<AccessibilityViewCheckResult>();
        if (Build.VERSION.SDK_INT < 16) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "This check only runs on Android 4.1 and above.", view));
            return results;
        }
        if (!ViewAccessibilityUtils.isImportantForAccessibility(view)) {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not important for accessibility.", view));
            return results;
        }
        for (Class<? extends ViewGroup> clazz : blacklistedViewTypes) {
            if (!clazz.isAssignableFrom(view.getClass())) continue;
            String msg = String.format("Views of type %s are not checked for speakable text.", clazz.getName());
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, msg, view));
            return results;
        }
        if (this.shouldFocusView(view)) {
            if (TextUtils.isEmpty((CharSequence)AccessibilityCheckUtils.getSpeakableTextForView(view))) {
                results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, "View is missing speakable text needed for a screen reader", view));
            }
        } else {
            results.add(new AccessibilityViewCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, "View is not focused by a screen reader", view));
        }
        return results;
    }

    protected boolean shouldFocusView(View view) {
        return ViewAccessibilityUtils.shouldFocusView(view);
    }
}

